<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Detail Indikator</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="<?php echo e(url('/dukcapil')); ?>">Dukcapil</a></div>
      <div class="breadcrumb-item active"><a href="#">Detail Indikator</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Detail</h4>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <?php echo $detail_dukcapil; ?>

    </div>
  </div>
</div>
<div class="card card-primary">
  <div class="card-header">
    <h4>Indikator</h4>
  </div>
  <div class="card-body">
    <div class="table-responsive">
    <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>#</th>
                <th>Variabel</th>
                <th>Indikator</th>
                <th>Penjelasan</th>
                <th>Total Nilai</th>
                <th>Pilih Parameter</th>
                <th>Dokumen Pendukung</th>
            </tr>
          </thead>
          <tbody>
            <?php $no = 1; ?>
            <?php $__currentLoopData = $indikator; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($no++); ?></td>
                <td><?php echo e($i->variabel); ?></td>
                <td><?php echo e($i->nama); ?></td>
                <td><?php echo e($i->penjelasan); ?></td>
                <td>
                    <?php if(SMUDESA::IsUploadDataPendukung($i->id, $dukcapil->id)): ?>
                    <span><?php echo e($indikator_dukcapil->where('id_indikator', $i->id)->first()->nilai ?? "-"); ?></span>
                    <?php else: ?>
                    <span>-</span>
                    <?php endif; ?>
                </td>
                <td>
                    <a href="javascript:;" onclick="getParameter(<?php echo e($i->id); ?>)" class="text-primary" data-toggle="modal" data-target="#modalParameter">
                        <i class="fas fa-pen"></i>
                    </a>

                     <?php echo e(SMUDESA::GetSelectedParameter($i->id, $dukcapil->id)); ?>

                </td>
                <td>
                    <a href="<?php echo e(url('dukcapil/dokumen_pendukung')); ?>?id_indikator=<?php echo e($i->id); ?>&id_dukcapil=<?php echo e($dukcapil->id); ?>&redirect=<?php echo e(request()->url()); ?>" class="btn btn-success btn-sm text-white">
                        <i class="fas fa-folder-plus"></i> Upload
                    </a>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
    </div>
  </div>
</div>

<div class="card card-primary">
  <div class="card-body text-right">
    <a href="<?php echo e(url('dukcapil')); ?>" class="btn btn-primary">Kembali</a>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modalParameter" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" data-backdrop="static" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Update Parameter</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="POST" action="<?php echo e(url('dukcapil/simpan_parameter')); ?>">
                <div class="modal-body">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="jenis" id="jenis">
                    <input type="hidden" name="indikator" id="id_indikator">
                    <input type="hidden" value="<?php echo e($dukcapil->id); ?>" name="id_dukcapil" id="id_dukcapil">

                    <div id="divParameter"></div>

                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Submit</button>

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>

<script>
    function getParameter(id_indikator)
    {
        $("#id_indikator").val(id_indikator);
        $("#divParameter").empty();
        $.get("<?php echo e(url('dukcapil/get_parameter')); ?>?id_indikator=" + id_indikator +"&id_dukcapil="+$("#id_dukcapil").val(), function(result){
            $("#divParameter").html(result);

            $(".allownumericwithdecimal").on("keypress keyup blur",function (event) {
                $(this).val($(this).val().replace(/[^0-9\.|\,]/g,''));
                if(event.which == 44)
                {
                return true;
                }
                if ((event.which != 46 || $(this).val().indexOf('.') != -1) && (event.which < 48 || event.which > 57  )) {

                event.preventDefault();
                }
            });
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\E-Open\resources\views/dukcapil/detail_indikator.blade.php ENDPATH**/ ?>