<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
  <title><?php echo e(config('app.name')); ?></title>
  <!-- General CSS Files -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/app.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/bundles/prism/prism.css')); ?>">
  <!-- Template CSS -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/components.css')); ?>">
  <!-- Custom style CSS -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom.css')); ?>">
  <link rel='shortcut icon' type='image/x-icon' href="<?php echo e(asset('assets/img/favicon.ico')); ?>" />

  <?php echo $__env->yieldContent('css'); ?>
</head>

<body>
  <div class="loader"></div>
  <div id="app">
    <div class="main-wrapper main-wrapper-1">
      <div class="navbar-bg"></div>
      <nav class="navbar navbar-expand-lg main-navbar">
        <div class="form-inline mr-auto">
          <ul class="navbar-nav mr-3">
            <li><a href="#" data-toggle="sidebar" class="nav-link nav-link-lg collapse-btn"><i
                  class="fas fa-bars"></i></a></li>
            <li><a href="#" class="nav-link nav-link-lg fullscreen-btn">
                <i class="fas fa-expand"></i>
              </a>
            </li>
          </ul>
        </div>
        <ul class="navbar-nav navbar-right">
          <li class="dropdown"><a href="#" data-toggle="dropdown"
              class="nav-link dropdown-toggle nav-link-lg nav-link-user">
              
              <figure class="avatar mr-2 avatar-sm bg-warning text-white" data-initial="<?php echo e(Auth::user()->initials); ?>"></figure>
              <span class="d-sm-none d-lg-inline-block"></span></a>
            <div class="dropdown-menu dropdown-menu-right">
              <div class="dropdown-title">Hello <?php echo e(Auth::user()->name); ?></div>
                <a href="<?php echo e(url('/admin/profile')); ?>" class="dropdown-item has-icon">
                  <i class="far fa-user"></i> Profile
                </a>
              
              <div class="dropdown-divider"></div>
                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                <a href="#" onclick="event.preventDefault(); this.closest('form').submit();" class="dropdown-item has-icon text-danger">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
                </form>
            </div>
          </li>
        </ul>
      </nav>
      <div class="main-sidebar sidebar-style-2">
        <aside id="sidebar-wrapper">
          <div class="sidebar-brand">
            <a href="<?php echo e(url('dashboard')); ?>">
              <img alt="image" src="<?php echo e(asset('assets/img/logo.png')); ?>" class="header-logo" />
              <span class="logo-name"><?php echo e(config('app.name')); ?></span>
            </a>
          </div>
          <ul class="sidebar-menu">
            <li class="menu-header">Main</li>
            <li>
                <a class="nav-link" href="<?php echo e(url('/dashboard')); ?>"><i class="fas fa-home"></i><span>Dashboard</span></a>
            </li>
            <li>
                <a class="nav-link" href="<?php echo e(url('/layanans')); ?>"><i class="fas fa-angle-double-right"></i><span>Layanan</span></a>
            </li>
            <li>
                <a class="nav-link" href="<?php echo e(url('/layanans/status')); ?>"><i class="fas fa-angle-double-right"></i><span>Status</span></a>
            </li>
            <li>
                <a class="nav-link" href="#"><i class="fas fa-angle-double-right"></i><span>Halo Pamor</span></a>
            </li>
            <li>
                <a class="nav-link" href="#"><i class="fas fa-angle-double-right"></i><span>Buku Petunjuk</span></a>
            </li>
            <li>
                <a class="nav-link" href="<?php echo e(url('/formulirs')); ?>"><i class="fas fa-angle-double-right"></i><span>Formulir</span></a>
            </li>
            <li>
                <a class="nav-link" href="<?php echo e(url('/dukcapil')); ?>"><i class="fas fa-angle-double-right"></i><span>Dukcapil</span></a>
            </li>
            <li>
                <a class="nav-link" href="<?php echo e(url('/peta')); ?>"><i class="fas fa-angle-double-right"></i><span>Peta</span></a>
            </li>

            <?php if(Auth::user()->id_hak_akses == \App\Models\HakAkses::Admin || Auth::user()->id_hak_akses == \App\Models\HakAkses::AdminProvinsi || Auth::user()->id_hak_akses == \App\Models\HakAkses::AdminKabupaten): ?>
              

              <li class="menu-header">Admin</li>

              <li>
                <a class="nav-link" href="<?php echo e(url('/admin/management-user')); ?>"><i class="fas fa-users"></i><span>User</span></a>
              </li>

              <li class="dropdown">
                <a href="blank.html#" class="nav-link has-dropdown"><i class="fas fa-database"></i><span>Master Data</span></a>
                <ul class="dropdown-menu">
                  <li><a class="nav-link" href="<?php echo e(url('/admin/master/layanan')); ?>">Layanan</a></li>
                </ul>

                <?php if(Auth::user()->id_hak_akses == \App\Models\HakAkses::Admin): ?>

                <ul class="dropdown-menu">
                  <!-- <li><a class="nav-link" href="<?php echo e(url('/admin/aspek')); ?>">Aspek</a></li> -->
                  <li><a class="nav-link" href="<?php echo e(url('/admin/variabel')); ?>">Variabel</a></li>
                  <li><a class="nav-link" href="<?php echo e(url('/admin/indikator')); ?>">Indikator</a></li>
                  <li><a class="nav-link" href="<?php echo e(url('/admin/master_formulir')); ?>">Formulir</a></li>
                  <li><a class="nav-link" href="<?php echo e(url('/admin/provinsi')); ?>">Provinsi</a></li>
                  <li><a class="nav-link" href="<?php echo e(url('/admin/kabupaten')); ?>">Kab/Kota</a></li>
                  <li><a class="nav-link" href="<?php echo e(url('/admin/kecamatan')); ?>">Kecamatan</a></li>
                  <li><a class="nav-link" href="<?php echo e(url('/admin/kelurahan')); ?>">Kelurahan/Desa</a></li>
                </ul>
                <?php endif; ?>
              </li>
            <?php endif; ?>

          </ul>
        </aside>
      </div>
      <!-- Main Content -->

      <div class="main-content">
        <section class="section">
          <div class="section-body">
            <?php echo $__env->yieldContent('isi'); ?>
          </div>
        </section>
        <?php echo $__env->yieldContent('modal'); ?>
      </div>
      <footer class="main-footer">
        <div class="footer-left">
          Copyright &copy; <?php echo e(date('Y')); ?> <div class="bullet"></div> Design By <a href="<?php echo e(url('dashboard')); ?>">Dani Kurniawan</a>
        </div>
        <div class="footer-right">
        </div>
      </footer>
    </div>
  </div>
  <!-- General JS Scripts -->
  <script src="<?php echo e(asset('assets/js/app.min.js')); ?>"></script>

  <script src="<?php echo e(asset('assets/bundles/sweetalert/sweetalert.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/bundles/prism/prism.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/bundles/jquery-ui/jquery-ui.min.js')); ?>"></script>
  <!-- JS Libraies -->
  <!-- Page Specific JS File -->
  <!-- Template JS File -->

  <script>
    $(window).on('load', function () {
        <?php if(Session::has('pesan')): ?>
        swal({
            title: "<?php echo e(Session::get('pesan.header')); ?>",
            text: "<?php echo e(Session::get('pesan.message')); ?>",
            icon: "<?php echo e(Session::get('pesan.alert-type')); ?>",
            confirmButtonColor: '#DD6B55',
            confirmButtonText: 'Ok',
        });

        <?php endif; ?>
    });
  </script>



  <script src="<?php echo e(asset('assets/js/scripts.js')); ?>"></script>
  <?php echo $__env->yieldContent('js'); ?>
  <!-- Custom JS File -->
  <script src="<?php echo e(asset('assets/js/custom.js')); ?>"></script>


</body>

</html>
<?php /**PATH D:\xampp_736\htdocs\E-Open\resources\views/layout/template.blade.php ENDPATH**/ ?>