<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Dukcapil</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Dukcapil</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Dukcapil</h4>

    <div class="card-header-action">
        <a href="<?php echo e(url('dukcapil/tambah')); ?>" class="btn btn-primary">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </a>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>Provinsi</th>
                <th>Kabupaten</th>
                <th>Kecamatan</th>
                <th>Kode</th>
                <th>NIK</th>
                <th>No KK</th>
                <th>Nama Lengkap</th>
                <th>Skor</th>
                <th>Status</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script>
    var table_data = $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo e(url('dukcapil/get-data')); ?>",
        "columns": [
            { data: 'provinsi.name', name: 'provinsi.name' },
            { data: 'kabupaten.name', name: 'kabupaten.name' },
            { data: 'kecamatan.name', name: 'kecamatan.name' },
            { data: 'code', name: 'code' },
            { data: 'nik', name: 'nik' },
            { data: 'no_kk', name: 'no_kk' },
            { data: 'nama_lengkap', name: 'nama_lengkap' },
            { data: 'skor', name: 'skor' },
            { data: 'status', name: 'status' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    function edit_data(id)
    {
        var url = "<?php echo e(url('admin/provinsi')); ?>/"+id+"/edit";

        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id").val(data.id);
                $("#name").val(data.name);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id").val("");
        $("#name").val("");
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(url('dukcapil')); ?>/"+id+"/hapus",
                    success: function(data){
                        table_data.ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        table_data.ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\E-Open\resources\views/dukcapil/index.blade.php ENDPATH**/ ?>