

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/ionicons/css/ionicons.min.css')); ?>">
<style>
    .form-group{
        margin: 5px !important;
    }
</style>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/select2/dist/css/select2.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Edit Status</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="<?php echo e(url('layanans/status')); ?>">Status</a></div>
      <div class="breadcrumb-item active"><a href="#">Edit</a></div>
    </div>
</div>
<form action="<?php echo e(url('layanans/status/revise_layanan')); ?>" method="POST" enctype="multipart/form-data">
    <input type="hidden" name="id_user_layanan" value="<?php echo e($user_layanan->id); ?>">
    <?php echo csrf_field(); ?>
<div class="card card-primary">
    <div class="card-header">
        <h4>Edit</h4>
    </div>
    <div class="card-body">
        <div class="row">
            <div  class="col-md-12" id="accordion">
                <div class="accordion">
                    <div class="accordion-header" role="button" data-toggle="collapse" data-target="#panel-body-1" aria-expanded="false">
                        <h4>Data Layanan</h4>
                    </div>
                    <div class="accordion-body collapse show" id="panel-body-1" style="">  
                        
                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">Nama Layanan</label>
                                <div class="col-md-6">
                                    <input type="text" readonly class="form-control" placeholder="" value="<?php echo e($user_layanan->layanan->nama ?? '-'); ?>" required>
                                </div>
                            </div>                           
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">Tingkatan</label>
                                <div class="col-md-6">
                                    <input type="text" readonly class="form-control" placeholder="" value="<?php echo e($user_layanan->layanan->tingkatan ?? '-'); ?>" required>
                                </div>
                            </div>                           
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">Lokasi Pengambilan</label>
                                <div class="col-md-6">
                                    <input type="text" readonly class="form-control" placeholder="" value="<?php echo e($user_layanan->layanan->lokasi_pengambilan ?? '-'); ?>" required>
                                </div>
                            </div>                           
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">Keterangan</label>
                                <div class="col-md-6">
                                    <input type="text" readonly class="form-control" placeholder="" value="<?php echo e($user_layanan->layanan->Keterangan ?? '-'); ?>" required>
                                </div>
                            </div>                           
                        </div>

                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">No Layanan</label>
                                <div class="col-md-6">
                                    <input type="text" readonly class="form-control" placeholder="" name="nik" id="nik" value="<?php echo e($user_layanan->no_layanan); ?>" required>
                                </div>
                            </div>                           
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">Kode Layanan</label>
                                <div class="col-md-6">
                                    <input type="text" readonly class="form-control" placeholder="" name="no_kk" id="no_kk" value="<?php echo e($user_layanan->kode); ?>" required>
                                </div>
                            </div> 
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">NIK</label>
                                <div class="col-md-6">
                                    <input type="text" class="form-control" placeholder="" name="nik" id="nik" value="<?php echo e($user_layanan->nik); ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">No KK</label>
                                <div class="col-md-6">
                                    <input type="text" class="form-control" placeholder="" name="no_kk" id="no_kk" value="<?php echo e($user_layanan->no_kk); ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">Nama Lengkap</label>
                                <div class="col-md-6">
                                    <input type="text" class="form-control" placeholder="" name="nama_lengkap" id="nama_lengkap" value="<?php echo e($user_layanan->nama_lengkap); ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">Provinsi</label>
                                <div class="col-md-6">
                                    <select name="id_provinsi" id="id_provinsi" class="form-control select2" required>
                                        <option value="<?php echo e($user_layanan->id_provinsi); ?>" selected><?php echo e($user_layanan->provinsi->name ?? '-'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">Kabupaten/Kota</label>
                                <div class="col-md-6">
                                    <select name="id_kabupaten" id="id_kabupaten" class="form-control select2" required>
                                        <option value="<?php echo e($user_layanan->id_kabupaten); ?>" selected><?php echo e($user_layanan->kabupaten->name ?? '-'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">Kecamatan</label>
                                <div class="col-md-6">
                                    <select name="id_kecamatan" id="id_kecamatan" class="form-control select2" required>
                                        <option value="<?php echo e($user_layanan->id_kecamatan); ?>" selected><?php echo e($user_layanan->kecamatan->name ?? '-'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <label class="col-md-3">Kelurahan</label>
                                <div class="col-md-6">
                                    <select name="id_kelurahan" id="id_kelurahan" class="form-control select2" required>
                                        <option value="<?php echo e($user_layanan->id_kelurahan); ?>" selected><?php echo e($user_layanan->kelurahan->name ?? '-'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="accordion">
                    <div class="accordion-header" role="button" data-toggle="collapse" data-target="#panel-body-3">
                        <h4>List</h4>
                    </div>
                    <div class="accordion-body collapse show" id="panel-body-3">
                        <?php $__currentLoopData = $user_layanan_detail->where('tipe','<>','File'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php if($val->tipe == "Text"): ?>
                            <div class="form-group">
                                <div class="row">
                                    <label class="col-md-3"><?php echo e($val->layanan_field->nama); ?></label>
                                    <div class="col-md-6">
                                        <input type="text" class="form-control" placeholder="" name="field_<?php echo e($val->id); ?>" id="field_<?php echo e($val->id); ?>" <?php echo e(($val->is_required == 1 ? "required" : "")); ?> value="<?php echo e($val->value); ?>">
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if($val->tipe == "Textarea"): ?>
                            <div class="form-group">
                                <div class="row">
                                    <label class="col-md-3"><?php echo e($val->layanan_field->nama); ?></label>
                                    <div class="col-md-6">
                                        <textarea name="field_<?php echo e($val->id); ?>" id="field_<?php echo e($val->id); ?>" class="form-control" <?php echo e(($val->is_required == 1 ? "required" : "")); ?>><?php echo e($val->value); ?></textarea>
                                    </div>
                                </div>                                
                            </div>
                            <?php endif; ?>

                            <?php if($val->tipe == "Date"): ?>
                            <div class="form-group">
                                <div class="row">
                                    <label class="col-md-3"><?php echo e($val->layanan_field->nama); ?></label>
                                    <div class="col-md-6">
                                        <input type="date" class="form-control" placeholder="" name="field_<?php echo e($val->id); ?>" id="field_<?php echo e($val->id); ?>" <?php echo e(($val->is_required == 1 ? "required" : "")); ?> value="<?php echo e($val->value); ?>">
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if($val->tipe == "Dropdown"): ?>
                            <div class="form-group">
                                <div class="row">
                                    <label class="col-md-3"><?php echo e($val->layanan_field->nama); ?></label>
                                    <div class="col-md-6">
                                        <select class="form-control" name="field_<?php echo e($val->id); ?>" id="field_<?php echo e($val->id); ?>" <?php echo e(($val->is_required == 1 ? "required" : "")); ?>>
                                            <option value="">-- Silakan Pilih --</option>
                                            <?php $__currentLoopData = SMUDESA::GetValueTipeDropdown($val->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($v != "File"): ?>
                                                <option value="<?php echo e($v->value); ?>" <?php echo e($v->value == $val->value ? "selected" : ""); ?>><?php echo e($v->value); ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="accordion">
                    <div class="accordion-header" role="button" data-toggle="collapse" data-target="#panel-body-4">
                        <h4>Lampiran</h4>
                    </div>
                    <div class="accordion-body collapse show" id="panel-body-4">
                        <?php $__currentLoopData = $user_layanan_detail->where('tipe','File'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($val->tipe == "File"): ?>
                            <div class="form-group">
                                <div class="row">
                                    <label class="col-md-3"><?php echo e($val->layanan_field->nama); ?></label>
                                    <div class="col-md-6">
                                        <input type="file" class="form-control" name="field_<?php echo e($val->id); ?>" id="field_<?php echo e($val->id); ?>">
                                        <a href="<?php echo e(asset('user_layanan/'.$val->value)); ?>" target="_blank"><i class="fas fa-download"></i> Download</a>
                                    </div>
                                </div>                                
                            </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                    </div>
                </div>                
            </div>
        </div>
        <hr>
        <div class="form-group">
            <div class="row">
                <label class="col-md-3">Status</label>
                <div class="col-md-6">
                    <input type="text" class="form-control" readonly value="<?php echo e($user_layanan->status); ?>">
                </div>
            </div>
        </div>
        <div class="form-group">
            <div class="row">
                <label class="col-md-3">Komentar</label>
                <div class="col-md-6">
                    <textarea class="form-control" readonly><?php echo e($user_layanan->komentar); ?></textarea>
                </div>
            </div>
        </div>

        <div class="row" style="margin-top: 25px">
            <div class="col-md-12 text-center">
                <a href="<?php echo e(url('layanans/status')); ?>" class="btn btn-secondary"> Kembali</a>
                <button type="submit" class="btn btn-primary"> KIRIM</button>
            </div>
        </div>
    </div>
</div>
</form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/select2/dist/js/select2.full.min.js')); ?>"></script>
<script>
    $(document).ready(function() {
        $("#id_provinsi").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_provinsi')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kabupaten").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_kab_kota_by_provinsi')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        provinsi_id: $("#id_provinsi").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kecamatan").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_kecamatan_by_kab')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        kabupaten_id: $("#id_kabupaten").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kelurahan").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_kelurahan_by_kecamatan')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        kecamatan_id: $("#id_kecamatan").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Open\resources\views/layanan/edit_status.blade.php ENDPATH**/ ?>