

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/select2/dist/css/select2.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<style>
    .form-group{
        margin: 5px !important;
    }
    .select2{
        width: 100% !important;
    }
  </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Akun</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Pengaturan</a></div>
      <div class="breadcrumb-item active"><a href="#">Akun</a></div>
    </div>
</div>

<?php if($errors->any()): ?>
    <div class="alert alert-danger alert-styled-left alert-bordered">
        <button type="button" class="close" data-dismiss="alert"><span>&times;</span><span class="sr-only">Close</span></button>
        <span><b>Error!</b></span><br> 
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo e($error); ?><br>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php endif; ?>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Akun</h4>

    <div class="card-header-action">
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </button>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th> Nama </th>
                <th> Email </th>
                <th> Hak Akses </th>
                <th> Aktif </th>
                <th> Aksi </th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Akun</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(url('admin/management-user/tambah')); ?>" method="post" id="frm_menu">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row"> 
                        <div class="col-md-6"> 
                            <div class="form-group"> 
                                <label class="control-label">NIK</label> 
                                <input type="text" class="form-control" name="nik" id="nik" required> 
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="form-group"> 
                                <label class="control-label">No KK</label> 
                                <input type="text" class="form-control" name="no_kk" id="no_kk" required> 
                            </div>
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-6"> 
                            <div class="form-group"> 
                                <label class="control-label">Nama</label> 
                                <input type="text" class="form-control" name="name" id="name" required> 
                                <input type="hidden" name="id_user" id="id_user">
                            </div> 
                        </div>
                        <div class="col-md-6"> 
                            <div class="form-group"> 
                                <label class="control-label">Provinsi</label> <br>
                                <select class="form-control select2" name="id_provinsi" id="id_provinsi">
                                    <option value="">-- Pilih Provinsi --</option>
                                </select>
                            </div> 
                        </div>
                    </div>
                    
                    <div class="row"> 
                        <div class="col-md-6"> 
                            <div class="form-group"> 
                                <label class="control-label">Kabupaten/Kota</label> 
                                <select class="form-control select2" name="id_kabupaten" id="id_kabupaten">
                                    <option value="">-- Pilih Kab/Kota --</option>
                                </select>
                            </div> 
                        </div>
                        <div class="col-md-6"> 
                            <div class="form-group"> 
                                <label class="control-label">Kecamatan</label> 
                                <select class="form-control select2" name="id_kecamatan" id="id_kecamatan">
                                    <option value="">-- Pilih Kecamatan --</option>
                                </select>
                            </div> 
                        </div>
                    </div>
                    
                    <div class="row"> 
                        <div class="col-md-6"> 
                            <div class="form-group"> 
                                <label class="control-label">Email</label> 
                                <input type="text" class="form-control" name="email" id="email" required> 
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="form-group"> 
                                <label class="control-label">Password</label> 
                                <input type="password" class="form-control" name="password" id="password" required> 
                            </div> 
                        </div>
                    </div>
    
                    <div class="row"> 
                        <div class="col-md-6"> 
                            <div class="form-group"> 
                                <label class="control-label">Hak Akses</label> 
                                <select name="id_hak_akses" class="form-control" id="id_hak_akses" onchange="CheckHakAkses()" required>
                                    <option value=""></option>
                                    <?php $__currentLoopData = $hak_akses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $h): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($h->id); ?>"><?php echo e($h->nama_hak_akses); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select> 
                            </div> 
                        </div>
                        <div class="col-md-6"> 
                            <div class="form-group"> 
                                <label class="control-label">Aktif</label> 
                                <select name="is_aktif" class="form-control" id="is_aktif" required>
                                    <option value=""></option>
                                    <option value="1">Ya</option>
                                    <option value="0">Tidak</option>
                                </select> 
                            </div> 
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/select2/dist/js/select2.full.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script>
    $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo e(url('admin/management-user/get-data')); ?>",
        "columns": [
            { data: 'name', name: 'name' }, 
            { data: 'email', searchable: 'email'},
            { data: 'nama_hak_akses', searchable: 'nama_hak_akses'},
            { data: 'is_aktif', searchable: false, sortable: false},
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    function edit_data(id)
    {  
        var url = "<?php echo e(url('admin/management-user')); ?>/"+id+"/edit";
        $("#id_induk").val("0");
        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id_user").val(data.id);
                $("#name").val(data.name);
                $("#email").val(data.email);
                $("#id_hak_akses").val(data.id_hak_akses).trigger("change");
                $("#is_aktif").val(data.is_aktif).trigger("change");
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id_user").val("");
        $("#name").val("");
        $("#password").val("");
        $("#email").val("");
        $("#id_hak_akses").val("").trigger("change");
        $("#is_aktif").val("").trigger("change");
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus Menu ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(url('admin/management-user')); ?>/"+id+"/hapus",
                    success: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        $('#tblData').DataTable().ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

    $(document).ready(function() {
        $("#id_provinsi").select2({
            dropdownParent: $("#modal-tambah"),
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_provinsi')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kabupaten").select2({
            dropdownParent: $("#modal-tambah"),
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_kab_kota_by_provinsi')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        provinsi_id: $("#id_provinsi").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kecamatan").select2({
            dropdownParent: $("#modal-tambah"),
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "<?php echo e(url('get_kecamatan_by_kab')); ?>",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        kabupaten_id: $("#id_kabupaten").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    });

    function CheckHakAkses()
    {
        var id_hak_akses = $("#id_hak_akses").val();

        if(id_hak_akses == 1) //admin
        {
            $("#id_provinsi").attr("required", false);
            $("#id_kabupaten").attr("required", false);
            $("#id_kecamatan").attr("required", false);
        }
        else if(id_hak_akses == 2 || id_hak_akses == 6) //user
        {
            $("#id_provinsi").attr("required", true);
            $("#id_kabupaten").attr("required", true);
            $("#id_kecamatan").attr("required", true);
        }
        else if(id_hak_akses == 3) //Admin Provinsi
        {
            $("#id_provinsi").attr("required", true);
            $("#id_kabupaten").attr("required", false);
            $("#id_kecamatan").attr("required", false);
        }
        else if(id_hak_akses == 4) //Admin Kab/Kota
        {
            $("#id_provinsi").attr("required", true);
            $("#id_kabupaten").attr("required", true);
            $("#id_kecamatan").attr("required", false);
        }
        else if(id_hak_akses == 5) //Admin Kecamatan
        {
            $("#id_provinsi").attr("required", true);
            $("#id_kabupaten").attr("required", true);
            $("#id_kecamatan").attr("required", true);
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp_736\htdocs\E-Open\resources\views/user/index.blade.php ENDPATH**/ ?>