<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/datatables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('isi'); ?>
<div class="section-header">
    <h1>Dokumen Pendukung</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Detail Indikator</a></div>
      <div class="breadcrumb-item active"><a href="#">Dokumen Pendukung</a></div>
    </div>
</div>
<div class="card card-primary">
  <div class="card-header">
    <h4>Dokumen Pendukung</h4>
  </div>
  <div class="card-body">
      <div class="row">
          
          <div class="col-md-12">
            <a href="<?php echo e($redirect); ?>" class="btn btn-info text-white">Kembali</a>
            <button data-toggle="modal" data-target="#modalParameter" onclick="bersih()" class="btn btn-success text-white"><i class="fas fa-upload"></i> Upload Dokumen</button>

          </div>
      </div>
    <hr>
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>#</th>
                
                <th>Tanggal</th>
                <th>Nomor</th>
                <th>Tentang</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php $no = 1; ?>
            <?php $__currentLoopData = $dokumen; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($no++); ?></td>
                
                <td><?php echo e($d->tanggal); ?></td>
                <td><?php echo e($d->nomor); ?></td>
                <td><?php echo e($d->tentang); ?></td>
                <td>
                    <button data-toggle="modal" data-target="#modalParameter" onclick="edit(<?php echo e($d->id); ?>)" class="btn btn-primary btn-sm text-white"><i class="fas fa-pencil-alt"></i> Edit</button>
                    <a href="<?php echo e(url('dukcapil/dokumen_pendukung/download/'.$d->id)); ?>" target="_blank" class="btn btn-success btn-sm text-white"><i class="fas fa-file-download"></i> Download</a>
                    <a onclick="return confirm('Apakah yakin dokumen akan dihapus?')" href="<?php echo e(url('dukcapil/dokumen_pendukung/hapus/'.$d->id)); ?>" class="btn btn-danger btn-sm text-white"><i class="fas fa-trash-alt"></i> Hapus</a>

                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="modalParameter" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" data-backdrop="static" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Upload Data Pendukung</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="POST" action="<?php echo e(url('dukcapil/simpan_dokumen_pendukung')); ?>" enctype="multipart/form-data">
                <div class="modal-body">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id_indikator" value="<?php echo e($indikator->id); ?>">
                    <input type="hidden" name="id_dukcapil" value="<?php echo e($dukcapil->id); ?>">
                    <input type="hidden" name="id" id="id">
                    
                    
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Nomor Surat/Dokumen</label>
                        <input type="text" class="form-control" name="nomor" id="nomor" required>
                    </div>
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Tanggal</label>
                        <input type="date" class="form-control" name="tanggal" id="tanggal" required>
                    </div>

                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Tentang</label>
                        
                        <textarea name="tentang" id="tentang" class="form-control" required></textarea>
                    </div>

                    <?php if($indikator->dokumen == "all"): ?>
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Dokumen</label><br>
                        <input type="file" accept=".pdf,.doc,.docx,.xls,.xlsx,.jpg,.jpeg,.png" name="dokumen" id="dokumen" required>
                    </div>
                    <?php elseif($indikator->dokumen == "pdf"): ?>
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Dokumen</label><br>
                        <input type="file" accept=".pdf" name="dokumen" id="dokumen" required>
                    </div>
                    <?php elseif($indikator->dokumen == "word"): ?>
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Dokumen</label><br>
                        <input type="file" accept=".doc,.docx" name="dokumen" id="dokumen" required>
                    </div>
                    <?php elseif($indikator->dokumen == "excel"): ?>
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Dokumen</label><br>
                        <input type="file" accept=".xls,.xlsx" name="dokumen" id="dokumen" required>
                    </div>
                    <?php elseif($indikator->dokumen == "image"): ?>
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Dokumen</label><br>
                        <input type="file" accept=".jpg,.jpeg,.png" name="dokumen" id="dokumen" required>
                    </div>
                    <?php endif; ?>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-success">Upload</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script>
    $("#tblData").DataTable();

    function edit(id)
    {
        $.get("<?php echo e(url('dukcapil/dokumen_pendukung/edit')); ?>/"+id, function(result){
            $("#id").val(result.id);
            $("#nomor").val(result.nomor);
            $("#tanggal").val(result.tanggal);
            $("#tentang").val(result.tentang);

            $("#dokumen").attr('required', false);
        });
    }

    function bersih()
    {
        $("#id").val("");
        $("#nomor").val("");
        $("#tanggal").val("");
        $("#tentang").val("");
        $("#dokumen").val("");

        $("#dokumen").attr('required', true);
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Open\resources\views/dukcapil/dokumen_pendukung.blade.php ENDPATH**/ ?>