<!DOCTYPE html>
<html lang="en">
<head>
<title>Integrasi Data</title>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="description" content="Travelix Project">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/styles/bootstrap4/bootstrap.min.css')); ?>">
<link href="<?php echo e(asset('assets/travelix/plugins/font-awesome-4.7.0/css/font-awesome.min.css')); ?>" rel="stylesheet" type="text/css">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/plugins/OwlCarousel2-2.2.1/owl.carousel.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/plugins/OwlCarousel2-2.2.1/owl.theme.default.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/plugins/OwlCarousel2-2.2.1/animate.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/styles/main_styles.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/styles/responsive.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/styles/offers_styles.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/travelix/styles/offers_responsive.css')); ?>">

</head>

<body>

<div class="super_container">
	
	<!-- Header -->

	<header class="header">

		<!-- Top Bar -->

		<div class="top_bar">
			<div class="container">
				<div class="row">
					<div class="col d-flex flex-row">
						
						<div class="user_box ml-auto">
							<div class="user_box_login user_box_link"><a href="<?php echo e(url('dashboard')); ?>">Login</a></div>
						</div>
					</div>
				</div>
			</div>		
		</div>

		<!-- Main Navigation -->

		<nav class="main_nav">
			<div class="container">
				<div class="row">
					<div class="col main_nav_col d-flex flex-row align-items-center justify-content-start">
						<div class="logo_container">
							<div class="logo"><a href="<?php echo e(url('/')); ?>">Integrasi Data</a></div>
						</div>
						<div class="main_nav_container ml-auto">
							<ul class="main_nav_list">
								<li class="main_nav_item"><a href="<?php echo e(url('/')); ?>">Home</a></li>
								<li class="main_nav_item"><a href="<?php echo e(url('front/hotel')); ?>">Hotel</a></li>
								<li class="main_nav_item"><a href="<?php echo e(url('front/wisata')); ?>">Wisata</a></li>
								<li class="main_nav_item"><a href="<?php echo e(url('dashboard')); ?>">Layanan Publik</a></li>
							</ul>
						</div>

						

						<div class="hamburger">
							<i class="fa fa-bars trans_200"></i>
						</div>
					</div>
				</div>
			</div>	
		</nav>

	</header>

	<div class="menu trans_500">
		<div class="menu_content d-flex flex-column align-items-center justify-content-center text-center">
			<div class="menu_close_container"><div class="menu_close"></div></div>
			<div class="logo menu_logo"><a href="#"><img src="images/logo.png" alt=""></a></div>
			<ul>
                <li class="menu_item"><a href="<?php echo e(url('/')); ?>">Home</a></li>
                <li class="menu_item"><a href="<?php echo e(url('front/hotel')); ?>">Hotel</a></li>
                <li class="menu_item"><a href="<?php echo e(url('front/wisata')); ?>">Wisata</a></li>
                <li class="menu_item"><a href="<?php echo e(url('dashboard')); ?>">Layanan Publik</a></li>
			</ul>
		</div>
	</div>

	<!-- Home -->

    <div class="home">
		<div class="home_background parallax-window" data-parallax="scroll" data-image-src="/assets/img/173822671.jpg"></div>
		<div class="home_content">
			<div class="home_title">Hotel</div>
		</div>
	</div>

    <div class="search">
		

		<!-- Search Contents -->
		
		<div class="container fill_height">
			<div class="row fill_height">
				<div class="col fill_height">

					<!-- Search Tabs -->

					<div class="search_tabs_container">
						<div class="search_tabs d-flex flex-lg-row flex-column align-items-lg-center align-items-start justify-content-lg-between justify-content-start">
							<div class="search_tab active d-flex flex-row align-items-center justify-content-lg-center justify-content-start"><img src="/assets/travelix/images/suitcase.png" alt=""><span>hotels</span></div>
						</div>		
					</div>

					<!-- Search Panel -->

					<div class="search_panel active">
						<form action="#" id="search_form_1" class="search_panel_content d-flex flex-lg-row flex-column align-items-lg-center align-items-start justify-content-lg-between justify-content-start">
							<div class="search_item">
								<div>destination</div>
								<input type="text" class="destination search_input" required="required">
							</div>
							<div class="search_item">
								<div>check in</div>
								<input type="date" class="check_in search_input" placeholder="YYYY-MM-DD">
							</div>
							<div class="search_item">
								<div>check out</div>
								<input type="date" class="check_out search_input" placeholder="YYYY-MM-DD">
							</div>
							
                            <div class="search_item">
								<button class="button search_button">search<span></span><span></span><span></span></button>
							</div>
							
						</form>
					</div>
				</div>
			</div>
		</div>		
	</div>
	
	<div class="container" style="margin-bottom: 25px">
        <div class="row">
            <div class="col-lg-1 temp_col"></div>

            <div class="col-lg-12">
                <!-- Offers Grid -->

                <div class="offers_grid">

                    <!-- Offers Item -->
                    <?php $__currentLoopData = $hotel; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="offers_item rating_4">
                        <div class="row">
                            <div class="col-lg-1 temp_col"></div>
                            <div class="col-lg-3 col-1680-4">
                                <div class="offers_image_container">
                                    <div class="offers_image_background" style="background-image:url(<?php echo e(SMUDESA::get_first_foto_hotel($val->id)); ?>)"></div>
                                    <div class="offer_name"><a href="#"><?php echo e($val->nama); ?></a></div>
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="offers_content">
                                    <div class="offers_price"><?php echo SMUDESA::get_first_harga_hotel($val->id); ?><span>per malam</span></div>
                                    <div class="rating_r rating_r_4 offers_rating" data-rating="4">
                                        <i></i>
                                        <i></i>
                                        <i></i>
                                        <i></i>
                                        <i></i>
                                    </div>
                                    <p class="offers_text"><?php echo $val->alamat; ?></p>
                                    
                                    <div class="button book_button"><a href="<?php echo e(url('front/hotel/detail/'.$val->id)); ?>">Detail<span></span><span></span><span></span></a></div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>

        </div>
    </div>

	<!-- Copyright -->

	<div class="copyright">
		<div class="container">
			<div class="row">
				<div class="col-lg-3 order-lg-1 order-2  ">
					<div class="copyright_content d-flex flex-row align-items-center">
						<div><!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. -->
Copyright &copy;<script>document.write(new Date().getFullYear());</script> All rights reserved | This template is made with <i class="fa fa-heart-o" aria-hidden="true"></i> by <a href="https://colorlib.com" target="_blank">Colorlib</a>
<!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. --></div>
					</div>
				</div>
				<div class="col-lg-9 order-lg-2 order-1">
					<div class="footer_nav_container d-flex flex-row align-items-center justify-content-lg-end">
						<div class="footer_nav">
							<ul class="footer_nav_list">
								
                                <li class="footer_nav_item"><a href="#">Home</a></li>
                                <li class="footer_nav_item"><a href="#">Hotel</a></li>
                                <li class="footer_nav_item"><a href="#">Wisata</a></li>
                                <li class="footer_nav_item"><a href="#l">Layanan Publik</a></li>
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

</div>

<script src="<?php echo e(asset('assets/travelix/js/jquery-3.2.1.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/styles/bootstrap4/popper.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/styles/bootstrap4/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/plugins/OwlCarousel2-2.2.1/owl.carousel.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/plugins/easing/easing.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/js/custom.js')); ?>"></script>
<script src="<?php echo e(asset('assets/travelix/plugins/parallax-js-master/parallax.min.js')); ?>"></script>
</body>

</html><?php /**PATH C:\xampp\htdocs\E-Open\resources\views/front_end/hotel/index_new.blade.php ENDPATH**/ ?>