<?php
namespace App\Helpers;

use App\Models\PendaftaranProgram;
use App\Models\Pembayaran;
use App\Models\Program;
use App\Models\IndikatorDukcapil;
use App\Models\Indikator;
use App\Models\IndeksDukcapil;
use App\Models\HotelFoto;
use App\Models\Room;
use App\Models\WisataFoto;
use App\Models\WisataPaket;
use App\Models\RoomFoto;
use App\Models\WisataPaketFoto;
use Carbon\Carbon;
use Mail;
use DB;

class SMUDESA {

    const SANGAT_MISKIN = "Sangat Miskin";
    const MISKIN = "Miskin";
    const HAMPIR_MISKIN = "Hampir Miskin";
    const RENTAN_MISKIN = "Rentan Miskin";
    const TIDAK_MISKIN = "Tidak Miskin";
    const BELUM_INPUT_DATA = "Belum Input Data";

    public static function GetKuotaTersedia($id_program)
    {
        $program = Program::find($id_program);
        $total_pendaftar = PendaftaranProgram::where('id_program', $id_program)->where('status', 'Diterima')->count();

        $tersedia = $program->kuota - $total_pendaftar;
        return $tersedia;
    }

    public static function GetDurasi($tanggal, $jam_mulai, $jam_selesai)
    {
        $startTime = Carbon::parse($tanggal." ".$jam_mulai);
        $endTime = Carbon::parse($tanggal." ".$jam_selesai);

        $totalDuration =  $startTime->diffInMinutes($endTime);


        return $totalDuration. " Menit";
    }

    public static function SendEmail($penerima, $template, $id = 0)
    {
        $view = "";
        $data = array();

        if($template == "pendaftaran_diterima")
        {
            $view = "email_template.pendaftaran_diterima";
            $data['pendaftaran'] = PendaftaranProgram::find($id);
            $data['pembayaran'] = Pembayaran::where('id_pendaftaran_program', $id)->first();
        }
        else if($template == "pendaftaran_ditolak")
        {
            $view = "email_template.pendaftaran_ditolak";
            $data['pendaftaran'] = PendaftaranProgram::find($id);
            $data['pembayaran'] = Pembayaran::where('id_pendaftaran_program', $id)->first();
        }

        Mail::send($view, $data, function($message) use($penerima) {
            $message->to($penerima)
            ->subject('SMU DESA');
        });
    }

    public static function GetTipeFields()
    {
        $data = ['Text', 'Dropdown', 'Date', 'Textarea', 'File'];

        return $data;
    }
    public static function GetJenisLampiran()
    {
        $data = ['Gambar', 'PDF', 'Word', 'Excel', 'Zip', 'All'];

        return $data;
    }

    public static function GetValueTipeDropdown($id_layanan_field)
    {
        $data = DB::table('layanan_field_dropdown_values')->where('id_layanan_field', $id_layanan_field)->get();

        return $data;
    }

    public static function IsUploadDataPendukung($id_indikator, $id_dukcapil)
    {
        $a = DB::table('dokumen_pendukung')
            ->where('id_indikator', '=', $id_indikator)
            ->where('id_dukcapil', '=', $id_dukcapil)
            // ->where('tahun', '=', $tahun)
            ->first();

        return ($a == null ? false : true);
    }

    public static function GetSelectedParameter($id_indikator, $id_dikcapil)
    {
        $ceksubmit = IndikatorDukcapil::where('id_dukcapil', '=', $id_dikcapil)
                ->where('id_indikator', '=', $id_indikator)
                ->first();

        $indikator = Indikator::where('id', $id_indikator)->first();

        if($ceksubmit != null)
        {
            if($indikator->jenis == "Pilihan")
            {
                $parameter = DB::table('parameters')->Where('id', $ceksubmit->id_parameter)->OrWhere('nama', $ceksubmit->parameter)->first();

                if($parameter != null)
                {
                    return $parameter->nama;
                }
            }
            else if($indikator->jenis == "Kuantitas")
            {
                return $ceksubmit->kuantitas;
            }
            else
            {
                return $ceksubmit->kualitas;
            }
        }
        else
        {
            return "";
        }
    }

    public static function GenerateNilai($id_dukcapil, $indikator_id, $nilai)
    {
        $data = Indikator::where('id', $indikator_id)->first();

        $hasil = 0;
        if($data->jenis == "Pilihan")
        {
            $hasil = $nilai * $data->bobot;
        }
        // else if($data->jenis == "Kuantitas")
        // {
        //     $profil_id = $data->id_profil;
        //     $data_profil = ProfilPemda::where('id_profil', $profil_id)
        //                         ->where('id_kabupaten', $id_kabupaten)
        //                         ->first();

        //     if($data_profil == null)
        //     {
        //         return 0;
        //     }
        //     else
        //     {
        //         $range = DB::table('parameter_ranges')->where('id_indikator', $indikator_id)->get();

        //         $nilai_profil = $data_profil->value;

        //         if($nilai_profil == 0)
        //         {
        //             return 0;
        //         }
        //         else
        //         {
        //             $nilai_range = ($nilai / $nilai_profil) * 100;

        //             $nilai_hasil = 0;
        //             foreach($range as $key => $item)
        //             {
        //                 if($key == 5)
        //                 {
        //                     if($nilai_range >= $item->range_start)
        //                     {
        //                         $nilai_hasil = $item->nilai;
        //                     }
        //                 }
        //                 else
        //                 {
        //                     if($nilai_range <= $item->range_end && $nilai_range >= $item->range_start)
        //                     {
        //                         $nilai_hasil = $item->nilai;
        //                     }
        //                 }
        //             }

        //             return $nilai_hasil * $data->bobot;
        //         }
        //     }
        // }
        // else
        // {
        //     $hasil = 0;
        // }

        return $hasil;
    }

    public static function GenerateSkorIndeks($id_dukcapil)
    {
        //group by variabel
        $total_index = IndikatorDukcapil::where('id_dukcapil', $id_dukcapil)
                        ->select(DB::raw('(SUM(indikator_dukcapil.nilai)) as nilai'))
                        ->join('indikators as i','indikator_dukcapil.id_indikator','=','i.id')
                        ->join('variabels as v','i.id_variabel','=','v.id')
                        // ->where('indikator_dukcapil.tahun', $tahun)
                        ->where('indikator_dukcapil.is_upload_data_pendukung', 1)
                        ->groupBy('v.id')
                        ->get();

        // $total_index_fungsional = IndikatorKabupaten::where('id_kabupaten', $kabupaten)
        //                 ->select(DB::raw('(SUM(indikator_kabupaten.nilai) / 3) as nilai'))
        //                 ->join('indikators as i','indikator_kabupaten.id_indikator','=','i.id')
        //                 ->join('variabels as v','i.id_variabel','=','v.id')
        //                 ->join('aspeks as a','v.id_aspek','=','a.id')
        //                 ->where('indikator_kabupaten.tahun', $tahun)
        //                 ->where('indikator_kabupaten.is_upload_data_pendukung', 1)
        //                 ->where('i.type', 'Fungsional')
        //                 ->groupBy('a.id')
        //                 ->get();
        // $total_index_nonfungsional = IndikatorKabupaten::where('id_kabupaten', $kabupaten)
        //                 ->select(DB::raw('(SUM(indikator_kabupaten.nilai) / 3) as nilai'))
        //                 ->join('indikators as i','indikator_kabupaten.id_indikator','=','i.id')
        //                 ->join('variabels as v','i.id_variabel','=','v.id')
        //                 ->join('aspeks as a','v.id_aspek','=','a.id')
        //                 ->where('indikator_kabupaten.tahun', $tahun)
        //                 ->where('indikator_kabupaten.is_upload_data_pendukung', 1)
        //                 ->where('i.type', 'Non Fungsional')
        //                 ->groupBy('a.id')
        //                 ->get();

        $total_index = $total_index->sum('nilai');
        // $total_index_fungsional = $total_index_fungsional->sum('nilai');
        // $total_index_nonfungsional = $total_index_nonfungsional->sum('nilai');

        $eksis_indeks = IndeksDukcapil::where('id_dukcapil', $id_dukcapil)
                            // ->where('tahun', $tahun)
                            ->first();

        if($eksis_indeks != null)
        {
            $eksis_indeks->skor = $total_index;
            // $eksis_indeks->indeks = $total_index;
            // $eksis_indeks->indeks_fungsional = $total_index_fungsional;
            // $eksis_indeks->indeks_nonfungsional = $total_index_nonfungsional;
            $eksis_indeks->updated_at = Carbon::now();
            $eksis_indeks->save();
        }
        else
        {
            $isi = [];
            $isi['id_dukcapil'] = $id_dukcapil;
            // $isi['tahun'] = $tahun;
            $isi['skor'] = $total_index;
            $isi['indeks'] = $total_index;
            // $isi['indeks_fungsional'] = $total_index_fungsional;
            // $isi['indeks_nonfungsional'] = $total_index_nonfungsional;
            $isi['created_at'] = date('Y-m-d H:i:s');
            $isi['updated_at'] = date('Y-m-d H:i:s');

            DB::table('indeks_dukcapil')->insert($isi);
        }

        return "Success";
    }

    public static function GetPredikat($nilai)
    {
        $predikat = self::BELUM_INPUT_DATA;
        $warna = "#c0c0c0";

        if($nilai > 0 && $nilai <= 1206)
        {
            $predikat = self::SANGAT_MISKIN;
            $warna = "#ff1a1a";
        }
        else if($nilai > 1206 && $nilai <= 1411)
        {
            $predikat = self::MISKIN;
            $warna = "#29a329";
        }
        else if($nilai > 1411 && $nilai <= 1511)
        {
            $predikat = self::HAMPIR_MISKIN;
            $warna = "#4287f5";
        }
        else if($nilai > 1511 && $nilai <= 1601)
        {
            $predikat = self::RENTAN_MISKIN;
            $warna = "#4287f5";
        }
        else if($nilai > 1601)
        {
            $predikat = self::TIDAK_MISKIN;
            $warna = "#4287f5";
        }

        return "<span style='color: ".$warna."'>".$predikat."</span>";
    }

    public static function GetPredikatOnly($nilai)
    {
        $predikat = self::BELUM_INPUT_DATA;
        $warna = "#c0c0c0";

        if($nilai > 0 && $nilai <= 1206)
        {
            $predikat = self::SANGAT_MISKIN;
        }
        else if($nilai > 1206 && $nilai <= 1411)
        {
            $predikat = self::MISKIN;
        }
        else if($nilai > 1411 && $nilai <= 1511)
        {
            $predikat = self::HAMPIR_MISKIN;
        }
        else if($nilai > 1511 && $nilai <= 1601)
        {
            $predikat = self::RENTAN_MISKIN;
        }
        else if($nilai > 1601)
        {
            $predikat = self::TIDAK_MISKIN;
        }

        return $predikat;
    }

    public static function get_first_foto_hotel($id_hotel)
    {
        $foto = HotelFoto::where('id_hotel', $id_hotel)->first();

        if($foto == null)
        {
            return asset('assets/front_end/images/blog-1-720x480.jpg');
        }
        else
        {
            return asset('gambar_hotel/'.$id_hotel.'/'.$foto->foto);
        }
    }

    public static function get_first_harga_hotel($id_hotel)
    {
        $harga = Room::where('id_hotel', $id_hotel)->select(DB::raw('MIN(harga) as min, MAX(harga) as max'))->groupBy('id_hotel')->first();

        if($harga == null)
        {
            return "";
        }
        else
        {
            if($harga->min == $harga->max)
            {
                return "Rp. ". number_format($harga->min);    
            }
            else
            {
                return "Rp. ". number_format($harga->min);
                // .' - '. number_format($harga->max)
            }
            
        }
    }

    public static function get_first_foto_wisata($id_wisata)
    {
        $foto = WisataFoto::where('id_wisata', $id_wisata)->first();

        if($foto == null)
        {
            return asset('assets/front_end/images/blog-1-720x480.jpg');
        }
        else
        {
            return asset('gambar_wisata/'.$id_wisata.'/'.$foto->foto);
        }
    }

    public static function get_first_harga_wisata($id_wisata)
    {
        $harga = WisataPaket::where('id_wisata', $id_wisata)->select(DB::raw('MIN(harga) as min, MAX(harga) as max'))->groupBy('id_wisata')->first();

        if($harga == null)
        {
            return 0;
        }
        else
        {
            if($harga->min == $harga->max)
            {
                return "Rp. ". number_format($harga->min);    
            }
            else
            {
                return "Rp. ". number_format($harga->min);
                // .' - '. number_format($harga->max)
            }
        }
    }

    public static function get_first_foto_kamar($id_kamar)
    {
        $foto = RoomFoto::where('id_room', $id_kamar)->first();

        if($foto == null)
        {
            return asset('assets/front_end/images/blog-1-720x480.jpg');
        }
        else
        {
            return asset('gambar_kamar/'.$id_kamar.'/'.$foto->foto);
        }
    }

    public static function get_first_foto_paket($id_paket)
    {
        $foto = WisataPaketFoto::where('id_wisata_paket', $id_paket)->first();

        if($foto == null)
        {
            return asset('assets/front_end/images/blog-1-720x480.jpg');
        }
        else
        {
            return asset('gambar_paket/'.$id_paket.'/'.$foto->foto);
        }
    }
}
