<?php

namespace App\Http\Controllers;

use App\Models\BuktiBayar;
use App\Models\PengajuanHaki;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use DataTables;

class BuktiBayarController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            if(Auth::user()->id_hak_akses == 1)
                $data = BuktiBayar::all();
            else
                $data = BuktiBayar::where('id_user', Auth::user()->id);

            return Datatables::of($data)
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {
                        return '<a href='.url('bukti-bayar/'.$id->id.'/edit').' title="Edit" class="btn btn-primary">Edit</a>
                        <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                    })
                    ->editColumn('file', function ($id) {
                        return '<a href='.asset('file_bukti_bayar/'.$id->file).' title="Edit" class="btn btn-primary" target="_blank">Download</a>';
                    })
                    ->make(true);
        }
    }

    public function index()
    {
    	return view('bukti_bayar.index');
    }

    public function tambah()
    {
        if(Auth::user()->id_hak_akses == 1)
            $pengajuan_haki = PengajuanHaki::select('kode_pengajuan')->get();
        else
            $pengajuan_haki = PengajuanHaki::select('kode_pengajuan')->where('id_user', Auth::user()->id)->get();

        $data['pengajuan_haki'] = $pengajuan_haki;
    	return view('bukti_bayar.tambah', $data);
    }

    public function simpan(Request $req)
    {
        $id             = $req->id;
        $id_pengajuan_haki  = $req->id_pengajuan_haki;
        $kode_pengajuan  = $req->kode_pengajuan;

        if(!empty($id)) {

            $pengajar = BuktiBayar::find($id);

        } else {

            $pengajar = new BuktiBayar;
            $pengajar->id_user = Auth::user()->id;
            $pengajar->status = "Review";
            $pengajar->kode_pengajuan = $kode_pengajuan;
            $pengajar->id_pengajuan_haki = $id_pengajuan_haki;
        }

        if($req->file != null)
        {
            $nama_file = "file_bukti_bayar_".time().'.'.$req->file->extension();

            $req->file->move('file_bukti_bayar', $nama_file);
            $pengajar->file = $nama_file;
        }

        $pengajar->save();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Data berhasil disimpan !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect('bukti-bayar')->with('pesan', $pesan);

    }

    public function edit($id)
    {
        $data['pengajuan_haki'] = BuktiBayar::findOrfail($id);

        return view('bukti_bayar.edit', $data);
    }

    public function hapus($id)
    {
        BuktiBayar::find($id)->delete();

        $data['message'] = 'Data berhasil dihapus';
        $data['issuccess'] = true;
        return response()->json($data, 200);
    }

    function get_pengajuan_haki($kode_pengajuan)
    {
        $pengajuan_haki = PengajuanHaki::where('kode_pengajuan', $kode_pengajuan)->first();

        $data['pengajuan_haki'] = $pengajuan_haki;

        return response()->json($pengajuan_haki, 200);
    }
}
