<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Program;
use App\Models\Kabupaten;
use App\Models\Dukcapil;
use App\Models\User;
use DB;
use Auth;

class FrontController extends Controller
{
    public function index()
    {
        $data['program'] = Program::where('status', 'Aktif')->get();

        return view('landing', $data);
    }

    public function get_kab_kota($id_provinsi)
    {
        $data = Kabupaten::where('province_id', $id_provinsi)->get();
        return response()->json($data, 200);
    }

    public function tentang()
    {
        $data['front'] = DB::table('fronts')->first();
        return view('tentang', $data);
    }

    public function profile()
    {
        $data['front'] = DB::table('fronts')->first();
        return view('profile', $data);
    }

    public function mekanisme_pendaftaran()
    {
        $data['front'] = DB::table('fronts')->first();
        return view('mekanisme_pendaftaran', $data);
    }

    public function GetModalContent($type)
    {
        if($type == "DAFTAR")
        {
            $modal = view('modals.daftar')->render();
        }
        else if($type == "PERMISI")
        {
            $klasifikasi = DB::table('klasifikasi_kepindahans')->get();
            $data['klasifikasi'] = $klasifikasi;
            $modal = view('modals.permisi', $data)->render();
        }
        else if($type == "HALO PAMOR")
        {
            $modal = view('modals.halo_pamor')->render();
        }
        else if($type == "ANDUK BANG BEK")
        {
            $data['jenis_permohonan'] = DB::table('jenis_permohonan_bang_beks')->get();
            $data['jenis_pelayanan'] = DB::table('jenis_pelayanans')->get();
            $data['alasan_permohonan'] = DB::table('alasan_permohonans')->get();
            $modal = view('modals.anduk_bang_bek', $data)->render();
        }
        else if($type == "DUDUK MESRA")
        {
            $modal = view('modals.duduk_mesra')->render();
        }
        else if($type == "SITI BAWA LUDO")
        {
            $data['dasar_permohonan'] = DB::table('dasar_permohonans')->get();
            $data['status_tinggal'] = DB::table('status_tinggals')->get();
            $modal = view('modals.siti_bawa_ludo', $data)->render();
        }
        else if($type == "MOTO KTP")
        {
            $data['jenis_permohonan'] = DB::table('jenis_permohonan_moto_ktps')->get();
            $modal = view('modals.moto_ktp', $data)->render();
        }
        else if($type == "SIP ORA")
        {
            $modal = view('modals.sip_ora')->render();
        }
        else{
            $modal = "<p>Template not found!</p>";
        }

        return $modal;
    }

    public function get_provinsi()
    {
        $query = request()->get('term')['term'];

        $prov = DB::table('provinces as a')->where('a.name','like','%'.$query.'%');
        $id_hak_akses = Auth::user() == null ? 0 : Auth::user()->id_hak_akses;

        if($id_hak_akses == 1)
        {
            $data = $prov->get();
        }
        else if($id_hak_akses == 3 || $id_hak_akses == 4 || $id_hak_akses == 5 || $id_hak_akses == 2)
        {
            $data = $prov->where('id', Auth::user()->id_provinsi)->get();
        }
        else
        {
            $data = $prov->get();
        }

        return response()->json($data);
    }

    public function get_kab_kota_by_provinsi()
    {
        $query = request()->get('term')['term'];
        $id_provinsi =  request()->get('provinsi_id');

        $kab = DB::table('regencies as a')->where('a.name','like','%'.$query.'%')->where('province_id', $id_provinsi);
        $id_hak_akses = Auth::user() == null ? 0 : Auth::user()->id_hak_akses;

        if($id_hak_akses == 1)
        {
            $data = $kab->get();
        }
        else if($id_hak_akses == 4 || $id_hak_akses == 5 || $id_hak_akses == 2)
        {

            $data = $kab->where('id', Auth::user()->id_kabupaten)->get();
        }
        else
        {
            $data = $kab->get();
        }

        // $data = DB::table('regencies as a')->where('a.name','like','%'.$query.'%')->where('province_id', $id_provinsi)->get();

        return response()->json($data);
    }

    public function get_kabupaten()
    {
        $query = request()->get('term')['term'];

        $data = DB::table('regencies as a')->where('a.name','like','%'.$query.'%')->get();

        return response()->json($data);
    }
    public function get_kecamatan()
    {
        $query = request()->get('term')['term'];
        $kabupaten_id =  request()->get('kabupaten_id');

        $data = DB::table('districts as a')->where('a.name','like','%'.$query.'%')->get();

        return response()->json($data);
    }
    public function get_kecamatan_by_kab()
    {
        $query = request()->get('term')['term'];
        $kabupaten_id =  request()->get('kabupaten_id');

        $kec = DB::table('districts as a')->where('a.name','like','%'.$query.'%')->where('regency_id', $kabupaten_id);
        $id_hak_akses = Auth::user() == null ? 0 : Auth::user()->id_hak_akses;

        if($id_hak_akses == 1)
        {
            $data = $kec->get();
        }
        // else if($id_hak_akses == 5 || $id_hak_akses == 2)
        // {
        //     $data = $kec->where('id', Auth::user()->id_kecamatan)->get();
        // }
        else
        {
            $data = $kec->get();
        }

        // $data = DB::table('districts as a')->where('a.name','like','%'.$query.'%')->where('regency_id', $kabupaten_id)->get();

        return response()->json($data);
    }

    public function get_kelurahan_by_kecamatan()
    {
        $query = request()->get('term')['term'];
        $kecamatan_id =  request()->get('kecamatan_id');

        $data = DB::table('villages as a')->where('a.name','like','%'.$query.'%')->where('a.district_id', $kecamatan_id)->get();

        return response()->json($data);
    }

    public function daftar(Request $req)
    {
        // $eksis = Dukcapil::where('nik', $req->nik)
        //             ->where('id', '<>', $req->id)
        //             ->exists();

        // if($eksis)
        // {
        //     return redirect('/login')->with('pesan', "NIK sudah terdaftar");
        // }

        $nik = $req->nik;
        $no_kk = $req->no_kk;
        $name = $req->name;
        $no_hp = $req->no_hp;
        $id_provinsi = $req->id_provinsi;
        $id_kabupaten = $req->id_kabupaten;
        $email = $req->email;
        $password = $req->password;

        $user = new User;
        $user->name = $name;
        $user->email = $email;
        $user->password = bcrypt($password);
        $user->nik = $nik;
        $user->no_kk = $no_kk;
        $user->id_hak_akses = 2;
        $user->is_aktif = 1;
        $user->id_provinsi = $id_provinsi;
        $user->id_kabupaten = $id_kabupaten;
        $user->save();

        // $dukcapil = new Dukcapil;
        // $dukcapil->code = $nik.".".$no_kk;
        // $dukcapil->nik = $nik;
        // $dukcapil->no_kk = $no_kk;
        // $dukcapil->nama_lengkap = $name;
        // $dukcapil->id_provinsi = $id_provinsi;
        // $dukcapil->id_kabupaten = $id_kabupaten;
        // $dukcapil->id_user = $user->id;

        // $dukcapil->save();

        return redirect('/login')->with('pesan_sukses', "Data sudah tersimpan, silakan LOGIN");
    }
}
