<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\HakAkses;
use App\Models\HakAksesUser;
use App\Models\Menu;
use DB;

class HakAksesController extends Controller
{
    public function index()
    {
    	$menu_0 = Menu::where('id_induk', 0)->get();
        $tree = '<ul id="tree" class="navigations">';
        foreach ($menu_0 as $value) {
            if($value->id ==1)
            {
                $ket = 'checked';
                $ket2 = 'hidden';
            }else{
                $ket = '';
                $ket2 = '';
            }
            $tree .= '<li><label '.$ket2.'><input type="checkbox" class="" name="id_menu[]" value="'.$value->id.'" '.$ket.' '.$ket2.' />  '.$value->menu.'</label>';

            if(count($value->childs)) {
                $tree .= $this->childView($value);
            }
        }
        $tree .='<ul>';
    	$hak_akses = HakAkses::all();
        $menu = Menu::all();
    	return view('hak_akses.index', compact('hak_akses','menu','tree'));
    }

    public function childView($value)
    {
        $html ='<ul>';

        foreach ($value->childs as $arr) {
            if(count($arr->childs)){
            $html .='<li><label><input type="checkbox" class="" name="id_menu[]" value="'.$arr->id.'" />  '.$arr->menu.'</label>';                  
                    $html.= $this->childView($arr);
                    
                }else{
                    $html .= '<li><label><input type="checkbox" class="" name="id_menu[]" value="'.$arr->id.'" />  '.$arr->menu.'</label>';                              
                    $html .= "</li>";
                }
                               
        }
            
            $html .="</ul>";
            return $html;
    }

    public function tambah(Request $request)
    {
    	$hak_akses = new HakAkses;
        $hak_akses->nama_hak_akses = $request->nama_hak_akses;
        $hak_akses->save();

        $id_menu = $request->id_menu;
        $jml = sizeof($id_menu);
        $arr_isi = array();
        $arr_isi['id_hak_akses'] = $hak_akses->id;
        $arr_isi['created_at'] = Carbon::now();
        $arr_isi['updated_at'] = Carbon::now();       
        
        for ($i=0; $i < $jml ; $i++) {                       
            $arr_isi['id_menu'] = $id_menu[$i]; 
            DB::table('hak_akses_user')->insert($arr_isi);                         
        }

        $pesan = array(
    		'header' => 'Terima Kasih',
    	    'message' => 'Data berhasil disimpan !', 
    	    'alert-type' => 'success'
    	);
    	
    	session()->put('pesan',$pesan);

    	return redirect()->back()->with('pesan',$pesan);
    }

    public function edit($id)
    {
        $hak_akses = HakAkses::edit_hak_akses($id);
        $hak_akses_user = HakAksesUser::where('id_hak_akses', $id)->get();
        $menu_0 = Menu::where('id_induk', 0)->get();
        $tree = '<ul id="tree" class="navigations">';

        foreach ($menu_0 as $value) {

            $ket = "";
            $ket2 = "";

            foreach ($hak_akses_user as $values) {

                if($value->id == $values->id_menu) {

                    $ket = "checked";
                }

                if($value->id == 1) {

                    $ket2 = "hidden";  

                }
            } 

            $tree .= '<li><label '.$ket2.'><input type="checkbox" name="id_menu[]" value="'.$value->id.'" '.$ket.' '.$ket2.' />  '.$value->menu.'</label>';         

            if(count($value->childs)) {
                $tree .= $this->childViewEdit($value,$id);
            }
        }
        $tree .='<ul>';
    	
    	return view('hak_akses.edit', compact('hak_akses','hak_akses_user','tree'));
    }

    public function childViewEdit($value,$id)
    {
        $hak_akses_user = HakAksesUser::where('id_hak_akses', $id)->get();
        $html ='<ul>';

        foreach ($value->childs as $arr) {            

            if(count($arr->childs)){

                $ket = "";

                foreach ($hak_akses_user as $values) {

                    if($arr->id == $values->id_menu) {

                        $ket = "checked";  

                    }
                    
                }
                $html .='<li><label><input type="checkbox" name="id_menu[]" value="'.$arr->id.'" '.$ket.' />  '.$arr->menu.'</label>'; 

                $html .= $this->childViewEdit($arr,$id);

            } else {

                $ket = "";
                foreach ($hak_akses_user as $values) {

                    if($arr->id == $values->id_menu) {

                        $ket = "checked"; 
                    }                    
                }

                $html .= '<li><label><input type="checkbox" name="id_menu[]" value="'.$arr->id.'" '.$ket.'/>  '.$arr->menu.'</label>';
                                             
                $html .="</li>";
            }
                               
        }
            
            $html .="</ul>";
            return $html;
    }

    public function update($id, Request $request)
    {
        HakAksesUser::hapus($id);

        $id_menu = $request->id_menu;
        $jml = sizeof($id_menu);
        $arr_isi = array();
        $arr_isi['id_hak_akses'] = $id;
        $arr_isi['created_at'] = Carbon::now();
        $arr_isi['updated_at'] = Carbon::now();       
        
        for ($i=0; $i < $jml ; $i++) {                       
            $arr_isi['id_menu'] = $id_menu[$i]; 
            DB::table('hak_akses_user')->insert($arr_isi);                         
        }
        
    	HakAkses::update_hak_akses($id,$request->nama_hak_akses);
    	
    	$pesan = array(
    		'header' => 'Terima Kasih',
    	    'message' => 'Data berhasil diubah !', 
    	    'alert-type' => 'success'
    	);
    	
    	session()->put('pesan',$pesan);

    	return redirect('admin/hak-akses')->with('pesan',$pesan);
    }
}
