<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Modul;
use App\Models\Materi;
use App\Models\Program;
use App\Models\Pembayaran;
use Auth;

class ModulController extends Controller
{
    public function index()
    {
        if(Auth::user()->id_hak_akses == 2)
        {
            $program_bayar = Program::with('pengajar')
                        ->select(['programs.*'])
                        ->join('pendaftaran_programs as a', 'programs.id','=','a.id_program')
                        ->join('pembayarans as b','a.id','=','b.id_pendaftaran_program')
                        ->where('b.status', Pembayaran::TELAHDIBAYAR)
                        ->where('a.id_user', Auth::user()->id);

            $program_gratis = Program::with('pengajar')
                                ->select(['programs.*'])
                                ->join('pendaftaran_programs as a', 'programs.id','=','a.id_program')
                                ->where('a.id_user', Auth::user()->id)
                                ->where('programs.is_pembayaran', 0);

            $program = $program_bayar->union($program_gratis)->distinct()->get();

        }
        else
        {
            $program = Program::with('pengajar')->get();
        }


        $data['program'] = $program;
        return view('modul.index', $data);
    }

    public function index_materi($id_program)
    {
        $data['materi'] = Materi::where('id_program', $id_program)->get();
        $data['id_program'] = $id_program;
        $data['program'] = Program::find($id_program);
        return view('modul.index_materi', $data);
    }

    public function index_modul($id_materi)
    {
        $materi = Materi::find($id_materi);
        $program = Program::find($materi->id_program);
        $data['modul'] = Modul::where('id_materi', $id_materi)->get();
        $data['materi'] = $materi;
        $data['program'] = $program;
        return view('modul.index_modul', $data);
    }

    public function tambah_materi(Request $req)
    {
        $id_materi = $req->id_materi;

        if(!empty($id_materi))
        {
            $new = Materi::find($id_materi);
            $new->id_program = $req->id_program;
            $new->nama = $req->nama;
            $new->deskripsi = $req->deskripsi;
            $new->save();

            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data berhasil diubah !',
                'alert-type' => 'success'
            );
        }
        else
        {
            $new = new Materi;
            $new->id_program = $req->id_program;
            $new->nama = $req->nama;
            $new->deskripsi = $req->deskripsi;
            $new->save();

            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data berhasil disimpan !',
                'alert-type' => 'success'
            );
        }

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);
    }

    public function edit_materi($id_materi)
    {
        $data = Materi::findOrfail($id_materi);

        return response()->json($data);
    }

    public function hapus_materi($id_materi)
    {
    	Materi::find($id_materi)->delete();

        $msg = 'Data berhasil dihapus';
        return ['message' => $msg];
    }

    public function tambah_modul(Request $req)
    {
        $id_modul = $req->id_modul;

        if(!empty($id_modul))
        {
            $new = Modul::find($id_modul);
            $new->id_materi = $req->id_materi;
            $new->nama = $req->nama;
            $new->tipe = $req->tipe;
            $new->deskripsi = $req->deskripsi;

            if($req->tipe == "Link")
            {
                if($req->link == null)
                {
                    $pesan = array(
                        'header' => 'GAGAL',
                        'message' => 'Link tidak boleh kosong !',
                        'alert-type' => 'error'
                    );

                    session()->put('pesan',$pesan);

                    return redirect()->back()->with('pesan', $pesan);
                }

                $new->link = $req->link;
            }
            else if($req->tipe == "File")
            {
                if($req->file == null)
                {
                    $pesan = array(
                        'header' => 'GAGAL',
                        'message' => 'File tidak boleh kosong !',
                        'alert-type' => 'error'
                    );

                    session()->put('pesan',$pesan);

                    return redirect()->back()->with('pesan', $pesan);
                }

                $fileName = $req->nama."_".time().'.'.$req->file->extension();

                $req->file->move('modul', $fileName);

                $new->file = $fileName;
            }

            $new->save();

            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data berhasil diubah !',
                'alert-type' => 'success'
            );
        }
        else
        {
            $new = new Modul;
            $new->id_materi = $req->id_materi;
            $new->nama = $req->nama;
            $new->tipe = $req->tipe;
            $new->deskripsi = $req->deskripsi;

            if($req->tipe == "Link")
            {
                if($req->link == null)
                {
                    $pesan = array(
                        'header' => 'GAGAL',
                        'message' => 'Link tidak boleh kosong !',
                        'alert-type' => 'error'
                    );

                    session()->put('pesan',$pesan);

                    return redirect()->back()->with('pesan', $pesan);
                }

                $new->link = $req->link;
            }
            else if($req->tipe == "File")
            {
                if($req->file == null)
                {
                    $pesan = array(
                        'header' => 'GAGAL',
                        'message' => 'File tidak boleh kosong !',
                        'alert-type' => 'error'
                    );

                    session()->put('pesan',$pesan);

                    return redirect()->back()->with('pesan', $pesan);
                }

                $fileName = $req->nama."_".time().'.'.$req->file->extension();

                $req->file->move('modul', $fileName);

                $new->file = $fileName;
            }

            $new->save();

            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data berhasil disimpan !',
                'alert-type' => 'success'
            );
        }

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);
    }

    public function edit_modul($id_materi)
    {
        $data = Modul::findOrfail($id_materi);

        return response()->json($data);
    }

    public function hapus_modul($id_materi)
    {
    	Modul::find($id_materi)->delete();

        $msg = 'Data berhasil dihapus';
        return ['message' => $msg];
    }

    public function download_modul($id_modul)
    {
        $modul = Modul::find($id_modul);
        $pathToFile = "modul/".$modul->file;
        return response()->download($pathToFile);
    }
}
