<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use DB;
use DataTables;
use App\Models\Program;
use App\Models\Pengajar;
use App\Models\PendaftaranProgram;
use App\Helpers\SMUDESA;
use Auth;

class ProgramController extends Controller
{
    public function get_data(Request $request)
    {
        if ($request->ajax()) {
            $data = Program::all();
            return Datatables::of($data)
                    ->addIndexColumn()
                    ->escapeColumns([])
                    ->editColumn('harga', function ($id) {
                        
                        if($id->harga == null)
                        {
                            return number_format(0,2);
                        }
                        else{
                            return number_format($id->harga,2);
                        }
                    })        
                    ->addColumn('nama_pengajar', function ($id) {
                        
                        return $id->pengajar->nama ?? "-";
                    })        
                    ->addColumn('jadwal', function ($id) {
                        
                        return date('d-M-Y', strtotime($id->mulai)). " s.d " .date('d-M-Y', strtotime($id->selesai));
                    })        
                    ->editColumn('lokasi', function ($id) {
                        
                        if($id->tipe_program == "Online")
                        {
                            return $id->tipe_program;
                        }
                        else
                        {
                            return $id->lokasi;
                        }
                    })        
                    ->addColumn('kuota_tersedia', function ($id) {
                        $total_pendaftar = PendaftaranProgram::where('id_program', $id->id)->where('status', 'Diterima')->count();
                        $tersedia = $id->kuota - $total_pendaftar;
                        return $tersedia;
                    })        
                    ->addColumn('aksi', function ($id) {
                        return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                                <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';

                                // <button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-warning" onclick="edit_data('.$id->id.');">Detail</button>
                    })        
                    ->make(true);
        }
        
    }
    
    public function index()
    {
    	$pengajar = Pengajar::all();

        $data['pengajar'] = $pengajar;
    	return view('program.index', $data);
    }

    public function tambah(Request $req)
    {
        $id             = $req->id_program;    
        $nama           = $req->nama;    
        $id_pengajar    = $req->id_pengajar;    
        $harga          = $req->harga;    
        $kuota          = $req->kuota;    
        $mulai          = $req->mulai;    
        $selesai        = $req->selesai;    
        $tipe_program   = $req->tipe_program;    
        $lokasi         = $req->lokasi;    
        $status         = $req->status;    
        $skor_kelulusan = $req->skor_kelulusan;    
        $pesan          = "";

        if(!empty($id)) {

            $menus = Program::find($id);
            $menus->nama            = $nama;
            $menus->id_pengajar     = $id_pengajar;
            $menus->harga           = $harga;
            $menus->kuota           = $kuota;
            $menus->mulai           = $mulai;
            $menus->selesai         = $selesai;
            $menus->tipe_program    = $tipe_program;
            $menus->lokasi          = $lokasi;
            $menus->status          = $status;
            $menus->skor_kelulusan  = $skor_kelulusan;
            $menus->updated_at      = Carbon::now();
            $menus->save();

            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data berhasil diubah !', 
                'alert-type' => 'success'
            );

        } else {

            $menus = new Program;
            $menus->nama            = $nama;
            $menus->id_pengajar     = $id_pengajar;
            $menus->harga           = $harga;
            $menus->kuota           = $kuota;
            $menus->mulai           = $mulai;
            $menus->selesai         = $selesai;
            $menus->tipe_program    = $tipe_program;
            $menus->lokasi          = $lokasi;
            $menus->status          = $status;
            $menus->skor_kelulusan  = $skor_kelulusan;
            $menus->created_at      = Carbon::now();
            $menus->save();
            
            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data berhasil disimpan !', 
                'alert-type' => 'success'
            );
        }
        
        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);

    }

    public function edit($id)
    {
        $data = Program::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
    	DB::beginTransaction();

        try {

            Program::find($id)->delete();

            DB::commit();

            $msg = 'Program berhasil dihapus';
            return ['message' => $msg];

        } catch (\Exception $e) {

            DB::rollback();

            $msg = $e->getMessage();
            return ['message' => $msg];
        } 
    }

    public function hapus_program_saya($id)
    {
    	DB::beginTransaction();

        try {

            PendaftaranProgram::find($id)->delete();

            DB::commit();

            $msg = 'Program berhasil dihapus';
            return ['message' => $msg];

        } catch (\Exception $e) {

            DB::rollback();

            $msg = $e->getMessage();
            return ['message' => $msg];
        } 
    }

    public function index_program_saya()
    {
        $data['program'] = Program::where('status', 'Aktif')->get();
        return view('program.index_program_saya', $data);
    }

    public function get_data_program_saya(Request $request)
    {
        if ($request->ajax()) {
            $data = PendaftaranProgram::with('program')->where('id_user', Auth::user()->id)->get();
            return Datatables::of($data)
                    ->addIndexColumn()
                    ->escapeColumns([])
                    ->addColumn('harga', function ($id) {
                        
                        if($id->program->harga == null)
                        {
                            return number_format(0,2);
                        }
                        else{
                            return number_format($id->program->harga,2);
                        }
                    })        
                    ->addColumn('nama_pengajar', function ($id) {
                        
                        return $id->program->pengajar->nama ?? "-";
                    })        
                    ->addColumn('jadwal', function ($id) {
                        
                        return date('d-M-Y', strtotime($id->program->mulai)). " s.d " .date('d-M-Y', strtotime($id->program->selesai));
                    })        
                    ->addColumn('lokasi', function ($id) {
                        
                        if($id->program->tipe_program == "Online")
                        {
                            return $id->program->tipe_program;
                        }
                        else
                        {
                            return $id->program->lokasi;
                        }
                    })   
                    ->addColumn('status', function ($id) {
                        
                        if($id->status == PendaftaranProgram::STATUSDITERIMA)
                        {
                            return '<div class="badge badge-success badge-shadow">'.$id->status.'</div>';
                        }
                        else if($id->status == PendaftaranProgram::STATUSDITOLAK)
                        {
                            return '<div class="badge badge-danger badge-shadow">'.$id->status.'</div>';
                        }
                        else if($id->status == PendaftaranProgram::STATUSMENUNGGU)
                        {
                            return '<div class="badge badge-warning badge-shadow">'.$id->status.'</div>';
                        }
                    })      
                    // ->addColumn('kuota_tersedia', function ($id) {
                    //     $total_pendaftar = PendaftaranProgram::where('id_program', $id->id_program)->where('status', 'Diterima')->count();
                    //     $tersedia = $id->kuota - $total_pendaftar;
                    //     return $tersedia;
                    // })        
                    ->addColumn('aksi', function ($id) {

                        if($id->status != PendaftaranProgram::STATUSDITERIMA)
                        {   
                            return '<button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                        }
                        else
                        {
                            return '<button disabled class="btn btn-danger text-white" title="Hapus">Hapus</button>';
                        }                           

                                // <button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-warning" onclick="edit_data('.$id->id.');">Detail</button>
                    })        
                    ->make(true);
        }
        
    }

    public function get_partial_detail_program_saya($id_program)
    {
        $data['program'] = Program::find($id_program);

        return view('program.partial_detail', $data)->render();
    }

    public function daftar_program_saya(Request $req)
    {
        $eksis = PendaftaranProgram::where('id_user', Auth::user()->id)
                    ->where('id_program', $req->id_program)
                    ->exists();

        if($eksis)
        {
            $pesan = array(
                'header' => 'GAGAL',
                'message' => 'Anda sudah terdaftar diprogram ini !', 
                'alert-type' => 'error'
            );
    
            session()->put('pesan',$pesan);
            return redirect()->back()->with('pesan', $pesan);
        }

        $sisa_kuota = SMUDESA::GetKuotaTersedia($req->id_program);

        if($sisa_kuota <= 0)
        {
            $pesan = array(
                'header' => 'GAGAL',
                'message' => 'Kuota sudah penuh diprogram ini !', 
                'alert-type' => 'error'
            );
    
            session()->put('pesan',$pesan);
            return redirect()->back()->with('pesan', $pesan);
        }

        $no_pendaftaran = PendaftaranProgram::no_reg();

        $new = new PendaftaranProgram;
        $new->no_pendaftaran = $no_pendaftaran;
        $new->id_program = $req->id_program;
        $new->id_user = Auth::user()->id;
        $new->status = PendaftaranProgram::STATUSMENUNGGU;
        $new->save();

        $pesan = array(
            'header' => 'SUKSES',
            'message' => 'Pendaftaran berhasil, saat ini sedang proses verifikasi !', 
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);
        return redirect()->back()->with('pesan', $pesan);
    }
}
