<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use DB;
use DataTables;
use App\Models\Ujian;
use App\Models\Program;
use App\Models\Pembayaran;
use App\Models\PesertaUjian;
use App\Models\JawabanPesertaUjian;
use App\Models\Soal;
use App\Models\Jawaban;
use App\Models\Sertifikat;
use Auth;

class UjianController extends Controller
{
    public function index()
    {
        $program = Program::where('status', 'Aktif')->get();

        $data['program'] = $program;

        return view('ujian.index', $data);
    }

    public function get_data(Request $request)
    {
        if ($request->ajax()) {

            if(Auth::user()->id_hak_akses == 2)
            {
                $data_bayar = Ujian::select(['ujians.*','p.nama as nama_program'])
                            ->join('pendaftaran_programs as a', 'ujians.id_program','=','a.id_program')
                            ->join('pembayarans as b','a.id','=','b.id_pendaftaran_program')
                            ->join('programs as p','ujians.id_program','=','p.id')
                            ->where('b.status', Pembayaran::TELAHDIBAYAR)
                            ->where('a.id_user', Auth::user()->id);

                $data_gratis = Ujian::select(['ujians.*','p.nama as nama_program'])
                            ->join('pendaftaran_programs as a', 'ujians.id_program','=','a.id_program')
                            ->join('programs as p', 'ujians.id_program','=','p.id')
                            ->where('a.id_user', Auth::user()->id)
                            ->where('p.is_pembayaran', 0);

                $data = $data_bayar->union($data_gratis)->get();
            }
            else
            {
                $data = Ujian::select(['ujians.*','p.nama as nama_program'])
                            ->join('programs as p', 'ujians.id_program','=','p.id')
                            ->get();
            }

            return Datatables::of($data)
                    ->addIndexColumn()
                    ->escapeColumns([])
                    ->addColumn('aksi', function ($id) {

                        if(Auth::user()->id_hak_akses == 2)
                        {
                            $peserta_ujian = PesertaUjian::where('id_ujian', $id->id)
                                                ->where('id_user', Auth::user()->id)
                                                ->first();

                            if($peserta_ujian != null)
                            {
                                if($peserta_ujian->status != null)
                                {
                                    //brrti udh mengikuti ujian
                                    return '<a href="'.url('admin/ujian/result/'.$id->id.'/'.Auth::user()->id).'" title="Ujian" class="btn btn-primary text-white">Hasil Ujian</a>';
                                }
                                else
                                {
                                    return '<a href="'.url('admin/ujian/open/'.$id->id).'" title="Ujian" class="btn btn-info text-white">OPEN</a>';
                                }
                            }
                            else
                            {
                                return '<a href="'.url('admin/ujian/open/'.$id->id).'" title="Ujian" class="btn btn-info text-white">OPEN</a>';
                            }
                        }
                        else
                        {
                            return '<button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-primary" onclick="edit_data('.$id->id.');">Edit</button>
                                <button class="btn btn-danger text-white" onclick="hapus('.$id->id.');" title="Hapus">Hapus</button>';
                        }


                                // <button data-toggle="modal" data-target="#modal-tambah" title="Edit" class="btn btn-warning" onclick="edit_data('.$id->id.');">Detail</button>
                    })
                    ->addColumn('pukul', function ($id) {

                        return date('H:i', strtotime($id->jam_mulai))." s.d ". date('H:i', strtotime($id->jam_selesai));
                    })
                    ->addColumn('duration', function ($id) {

                        $startTime = Carbon::parse($id->tanggal." ".$id->jam_mulai);
                        $endTime = Carbon::parse($id->tanggal." ".$id->jam_selesai);

                        $totalDuration =  $startTime->diffInMinutes($endTime);


                        return $totalDuration. " Menit";

                    })
                    ->editColumn('tanggal', function ($id) {

                        return date('d-M-Y', strtotime($id->tanggal));
                    })
                    ->make(true);
        }

    }

    public function tambah(Request $req)
    {
        $id = $req->id_ujian;

        if(!empty($id)) {

            $cek = Ujian::where('id_program', $req->id_program)
                        ->where('id','<>', $id)
                        ->exists();
            if($cek)
            {
                $pesan = array(
                    'header' => 'GAGAL',
                    'message' => 'Program sudah terdaftar ujian !',
                    'alert-type' => 'error'
                );

                session()->put('pesan',$pesan);

                return redirect()->back()->with('pesan', $pesan);
            }

            $menus = Ujian::find($id);
            $menus->id_program        = $req->id_program;
            $menus->tanggal           = $req->tanggal;
            $menus->jam_mulai         = $req->jam_mulai;
            $menus->jam_selesai       = $req->jam_selesai;
            $menus->syarat_kelulusan  = $req->syarat_kelulusan;
            $menus->updated_at        = Carbon::now();
            $menus->save();

            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data berhasil diubah !',
                'alert-type' => 'success'
            );

        } else {

            $cek = Ujian::where('id_program', $req->id_program)
                        ->exists();
            if($cek)
            {
                $pesan = array(
                    'header' => 'GAGAL',
                    'message' => 'Program sudah terdaftar ujian !',
                    'alert-type' => 'error'
                );

                session()->put('pesan',$pesan);

                return redirect()->back()->with('pesan', $pesan);
            }

            $menus = new Ujian;
            $menus->id_program        = $req->id_program;
            $menus->tanggal           = $req->tanggal;
            $menus->jam_mulai         = $req->jam_mulai;
            $menus->jam_selesai       = $req->jam_selesai;
            $menus->syarat_kelulusan  = $req->syarat_kelulusan;
            $menus->created_at        = Carbon::now();
            $menus->save();

            $pesan = array(
                'header' => 'Terima Kasih',
                'message' => 'Data berhasil disimpan !',
                'alert-type' => 'success'
            );
        }

        session()->put('pesan',$pesan);

        return redirect()->back()->with('pesan', $pesan);
    }

    public function edit($id)
    {
        $data = Ujian::findOrfail($id);

        return response()->json($data);
    }

    public function hapus($id)
    {
    	DB::beginTransaction();

        try {

            Ujian::find($id)->delete();

            DB::commit();

            $msg = 'Data berhasil dihapus';
            return ['message' => $msg];

        } catch (\Exception $e) {

            DB::rollback();

            $msg = $e->getMessage();
            return ['message' => $msg];
        }
    }

    public function open($id)
    {
        $ujian = Ujian::with('program')->where('id', $id)->first();

        $data['ujian'] = $ujian;

        return view('ujian.open', $data);
    }

    public function start(Request $req)
    {
        $id_ujian = $req->id_ujian;
        $id_user = Auth::user()->id;
        $id_program = $req->id_program;

        $cek = PesertaUjian::where('id_ujian', $id_ujian)
                ->where('id_user', $id_user)
                ->exists();

        if($cek)
        {
            $pesan = array(
                'header' => 'GAGAL',
                'message' => 'Anda sudah mengikuti ujian !',
                'alert-type' => 'error'
            );

            session()->put('pesan',$pesan);

            return redirect()->back()->with('pesan', $pesan);
        }

        $new = new PesertaUjian;
        $new->id_ujian = $id_ujian;
        $new->id_user = $id_user;
        $new->jam_mulai = date('H:i');
        $new->save();

        $soal = Soal::where('id_program', $id_program)->get();

        $data['soal'] = $soal;
        $data['ujian'] = Ujian::find($id_ujian);
        $data['id_program'] = $id_program;
        $data['id_peserta_ujian'] = $new->id;

        return view('ujian.start', $data);

    }

    public function kirim(Request $req)
    {
        $id_ujian = $req->id_ujian;
        $id_program = $req->id_program;
        $id_peserta_ujian = $req->id_peserta_ujian;
        $arr_id_soal = $req->id_soal;

        $ujian = Ujian::find($id_ujian);

        $peserta_ujian = PesertaUjian::find($id_peserta_ujian);
        $peserta_ujian->jam_selesai = date('H:i');

        $arr_skor = array();

        if($arr_id_soal != null)
        {
            for($i = 0; $i < count($arr_id_soal); $i++)
            {
                $attr_nama = "jawaban_".$arr_id_soal[$i];
                $id_soal = $arr_id_soal[$i];
                $id_jawaban = $req->$attr_nama;

                $cek_jawaban = Jawaban::where('id_soal', $id_soal)
                                    ->where('id', $id_jawaban)
                                    ->first();

                $soal = Soal::where('id', $id_soal)->first();
                $skor = 0;
                $jawaban_benar = 0;

                if($cek_jawaban != null)
                {
                    $skor = ($cek_jawaban->jawaban_benar == 1) ? $soal->skor : 0;
                    $jawaban_benar = ($cek_jawaban->jawaban_benar == 1) ? 1 : 0;
                }

                $arr_skor[] = $skor;

                $new_jawaban = new JawabanPesertaUjian;
                $new_jawaban->id_peserta_ujian = $id_peserta_ujian;
                $new_jawaban->id_soal = $id_soal;
                $new_jawaban->id_jawaban = $id_jawaban == null ? 0 : $id_jawaban;
                $new_jawaban->jawaban_benar = $jawaban_benar;
                $new_jawaban->poin = $skor;
                $new_jawaban->save();
            }
        }

        $total_skor = array_sum($arr_skor);

        $peserta_ujian->skor = $total_skor;

        if($total_skor >= $ujian->syarat_kelulusan)
        {
            $peserta_ujian->status = "LULUS";

            //Simpan ke Sertifikat
            $sertifikat = new Sertifikat;
            $sertifikat->id_program = $id_program;
            $sertifikat->id_user = Auth::user()->id;
            $sertifikat->save();
        }
        else
        {
            $peserta_ujian->status = "GAGAL";
        }

        $peserta_ujian->save();

        $pesan = array(
            'header' => 'Terima Kasih',
            'message' => 'Ujian anda telah selesai !',
            'alert-type' => 'success'
        );

        session()->put('pesan',$pesan);

        return redirect('admin/ujian')->with('pesan', $pesan);
    }

    public function result($id, $id_user)
    {
        $ujian = Ujian::with('program')->where('id', $id)->first();
        $peserta_ujian = PesertaUjian::where('id_ujian', $id)->where('id_user', $id_user)->first();

        $data['ujian'] = $ujian;
        $data['peserta_ujian'] = $peserta_ujian;

        return view('ujian.result', $data);
    }

    public function lihat_jawaban($id, $id_user)
    {
        $peserta_ujian = PesertaUjian::where('id_ujian', $id)->where('id_user', $id_user)->first();
        $jawaban_peserta = JawabanPesertaUjian::with(['program','soal'])->where('id_peserta_ujian', $peserta_ujian->id)->get();

        $data['peserta_ujian'] = $peserta_ujian;
        $data['jawaban_peserta'] = $jawaban_peserta;

        return view('ujian.lihat_jawaban', $data);
    }
}
