<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PerbaikanHakiRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'email' => 'required|email',
            'telp' => 'required|string',
            'id_jenis_haki' => 'required|integer',
            'id_satuan_kerja' => 'required|integer',
            'judul_kekayaan_intelektual' => 'required|string',
            'abstrak_kekayaan_intelektual' => 'required|string',
            'file_surat_pengajuan' => 'nullable|file|mimes:pdf,doc,docx|max:10240',
            'judul_file_pendukung.*' => 'nullable|string',
            'file_pendukung.*' => 'nullable|file|mimes:pdf,doc,docx|max:10240',
            'nama_kolabolator_internal.*' => 'nullable|string',
            'file_ktp_kolabolator_internal.*' => 'nullable|file|mimes:pdf,doc,docx,jpg,jpeg,png|max:10240',
            'file_npwp_kolabolator_internal.*' => 'nullable|file|mimes:pdf,doc,docx,jpg,jpeg,png|max:10240',
            'nama_kolabolator_eksternal.*' => 'nullable|string',
            'file_ktp_kolabolator_eksternal.*' => 'nullable|file|mimes:pdf,doc,docx,jpg,jpeg,png|max:10240',
            'file_npwp_kolabolator_eksternal.*' => 'nullable|file|mimes:pdf,doc,docx,jpg,jpeg,png|max:10240',
        ];
    }
}
