<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pembayaran extends Model
{
    use HasFactory;

    protected $table = 'pembayarans';

    public const PAYMENT_CHANNELS = ['credit_card', 'mandiri_clickpay', 'cimb_clicks',
	'bca_klikbca', 'bca_klikpay', 'bri_epay', 'echannel', 'permata_va',
	'bca_va', 'bni_va', 'other_va', 'gopay', 'indomaret',
	'danamon_online', 'akulaku'];

	public const EXPIRY_DURATION = 7;
	public const EXPIRY_UNIT = 'days';	  

	public const CHALLENGE = 'challenge';
	public const SUCCESS = 'success';
	public const SETTLEMENT = 'settlement';
	public const PENDING = 'pending';
	public const DENY = 'deny';
	public const EXPIRE = 'expire';
	public const CANCEL = 'cancel';
	public const TELAHDIBAYAR = 'Telah Dibayar';
	public const BEKUMDIBAYAR = 'Belum Dibayar';

    public function pendaftaran_program()
    {
        return $this->belongsTo(PendaftaranProgram::class, 'id_pendaftaran_program');
    }

    public static function no_trx() {
        
        $tmp = "TRX".date('Ymd');
        $last_no_app = self::where('no_transaksi', 'like', $tmp .'%' )->orderBy('created_at', 'DESC')->first();        

        if($last_no_app === null) {

            $no_selanjut_y =$tmp."00001";

        } else {

            $x = substr($last_no_app->no_transaksi, 11);
            $x = $x + 1;

            $panjang_x = strlen($x);

            if($panjang_x == 5) {
                $no_selanjut_y= $tmp.$x;
            } else if ($panjang_x == 4){
                $no_selanjut_y= $tmp."0".$x;    
            } else if ($panjang_x == 3){
                $no_selanjut_y= $tmp."00".$x;    
            } else if($panjang_x == 2){
                $no_selanjut_y= $tmp."000".$x;
            } else if($panjang_x == 1){
                $no_selanjut_y= $tmp."0000".$x;
            } else {
                $no_selanjut_y= $tmp."00000";
            }
        } 
        return $no_selanjut_y;
    }
}
