<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PerbaikanHaki extends Model
{
    use HasFactory;

    protected $table = 'perbaikan_haki';
    protected $guarded = [];

    public function pengajuan_haki()
    {
        return $this->belongsTo(PengajuanHaki::class, 'id_pengajuan_haki');
    }

    public function jenis_haki()
    {
        return $this->belongsTo(JenisHaki::class, 'id_jenis_haki');
    }

    public function file_pendukung()
    {
        return $this->hasMany(PerbaikanHakiFilePendukung::class, 'id_perbaikan_haki');
    }

    public function kolabolator()
    {
        return $this->hasMany(PerbaikanHakiKolabolator::class, 'id_perbaikan_haki');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'id_user');
    }
}
