<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Auth;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'id_hak_akses',
        'is_aktif',
        'nik',
        'tanggal_lahir',
        'jenis_kelamin',
        'id_provinsi',
        'id_kabupaten',
        'alamat',
        'no_telp',
        'file_pendukung',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getInitialsAttribute(){
        $name = Auth::user()->name;
        $name_array = explode(' ',trim($name));
    
        $firstWord = $name_array[0];

        if(count($name_array) > 1)
            $lastWord = $name_array[1][0];
        else
            $lastWord = "";
    
        return $firstWord[0]."".$lastWord;
    }

    public function hak_akses()
    {
        return $this->belongsTo(HakAkses::class, 'id_hak_akses');
    }

    public function provinsi()
    {
        return $this->belongsTo(Provinsi::class, 'id_provinsi');
    }

    public function kabupaten()
    {
        return $this->belongsTo(Kabupaten::class, 'id_kabupaten');
    }

    public function scopeGetList($query)
    {
        $query->select(['users.*','hak_akses.nama_hak_akses'])->join('hak_akses','users.id_hak_akses','=','hak_akses.id');

        return $query;
    }
}
