@extends('layout.template')
@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
<style>
.hidden{
    visibility: collapse;
}
</style>
@endsection
@section('isi')
<div class="section-header">
    <h1>Dashboard</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item active"><a href="#">Dashboard</a></div>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card card-statistic-1">
            <div class="card-icon bg-primary">
            </div>
            <div class="card-wrap">
                <div class="padding-20">
                    <div class="text-end">
                        <h3 class="font-light mb-0">
                            <i class="ti-arrow-up text-success"></i> 0
                        </h3>
                        <span class="text-muted">{{ SMUDESA::TIDAK_MISKIN }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card card-statistic-1">
            <div class="card-icon bg-success">
            </div>
            <div class="card-wrap">
                <div class="padding-20">
                    <div class="text-end">
                        <h3 class="font-light mb-0">
                            <i class="ti-arrow-up text-success"></i> 0
                        </h3>
                        <span class="text-muted">{{ SMUDESA::RENTAN_MISKIN }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card card-statistic-1">
            <div class="card-icon bg-warning">
            </div>
            <div class="card-wrap">
                <div class="padding-20">
                    <div class="text-end">
                        <h3 class="font-light mb-0">
                            <i class="ti-arrow-up text-success"></i> 0
                        </h3>
                        <span class="text-muted">{{ SMUDESA::HAMPIR_MISKIN }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card card-statistic-1">
            <div class="card-icon l-bg-yellow">
            </div>
            <div class="card-wrap">
                <div class="padding-20">
                    <div class="text-end">
                        <h3 class="font-light mb-0">
                            <i class="ti-arrow-up text-success"></i> 0
                        </h3>
                        <span class="text-muted">{{ SMUDESA::MISKIN }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card card-statistic-1">
            <div class="card-icon bg-danger">
            </div>
            <div class="card-wrap">
                <div class="padding-20">
                    <div class="text-end">
                        <h3 class="font-light mb-0">
                            <i class="ti-arrow-up text-success"></i> 0
                        </h3>
                        <span class="text-muted">{{ SMUDESA::SANGAT_MISKIN }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card card-statistic-1">
            <div class="card-icon bg-secondary">
            </div>
            <div class="card-wrap">
                <div class="padding-20">
                    <div class="text-end">
                        <h3 class="font-light mb-0">
                            <i class="ti-arrow-up text-success"></i> 0
                        </h3>
                        <span class="text-muted">{{ SMUDESA::BELUM_INPUT_DATA }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<div class="row">
    <div class="col-md-12">
        <div class="card">
            {{-- <div class="card-header">
              <h4>Detail</h4>
            </div> --}}
            <div class="card-body">
                <ul class="nav nav-tabs" id="myTab2" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a class="nav-link active" id="home-tab2" data-toggle="tab" href="#home2" role="tab" aria-controls="home" aria-selected="true">Detail</a>
                    </li>
                    {{-- <li class="nav-item" role="presentation">
                        <a class="nav-link" id="profile-tab2" data-toggle="tab" href="#profile2" role="tab" aria-controls="profile" aria-selected="false" tabindex="-1">{{ SMUDESA::TIDAK_MISKIN }}</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="contact-tab2" data-toggle="tab" href="#contact2" role="tab" aria-controls="contact" aria-selected="false" tabindex="-1">{{ SMUDESA::RENTAN_MISKIN }}</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="contact-tab3" data-toggle="tab" href="#contact3" role="tab" aria-controls="contact" aria-selected="false" tabindex="-1">{{ SMUDESA::HAMPIR_MISKIN }}</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="contact-tab4" data-toggle="tab" href="#contact4" role="tab" aria-controls="contact" aria-selected="false" tabindex="-1">{{ SMUDESA::MISKIN }}</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="contact-tab5" data-toggle="tab" href="#contact5" role="tab" aria-controls="contact" aria-selected="false" tabindex="-1">{{ SMUDESA::SANGAT_MISKIN }}</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="contact-tab6" data-toggle="tab" href="#contact6" role="tab" aria-controls="contact" aria-selected="false" tabindex="-1">{{ SMUDESA::BELUM_INPUT_DATA }}</a>
                    </li> --}}
                </ul>
                <div class="tab-content tab-bordered" id="myTab3Content">
                    <div class="tab-pane fade show active" id="home2" role="tabpanel" aria-labelledby="home-tab2">
                        <div class="form-group replyBox m-t-20">

                            <div class="row">
                              <div class="col-md-4">
                                <label>Pilih Provinsi</label>
                                <select class="form-control select2" name="id_provinsi" id="id_provinsi" style="width: 100%">
                                  <option value="">-- Silakan pilih --</option>
                                </select>
                              </div>
                              <div class="col-md-4">
                                <label>Pilih Kabupaten</label>
                                <select class="form-control select2" name="id_kabupaten" id="id_kabupaten" style="width: 100%">
                                  <option value="">-- Silakan pilih --</option>
                                </select>
                              </div>
                              <div class="col-md-4">
                                <label>Status</label>
                                <select class="form-control" name="status" id="status" style="width: 100%">
                                  <option value="0">Semua</option>
                                  <option value="{{ SMUDESA::TIDAK_MISKIN }}">{{ SMUDESA::TIDAK_MISKIN }}</option>
                                  <option value="{{ SMUDESA::RENTAN_MISKIN }}">{{ SMUDESA::RENTAN_MISKIN }}</option>
                                  <option value="{{ SMUDESA::HAMPIR_MISKIN }}">{{ SMUDESA::HAMPIR_MISKIN }}</option>
                                  <option value="{{ SMUDESA::MISKIN }}">{{ SMUDESA::MISKIN }}</option>
                                  <option value="{{ SMUDESA::SANGAT_MISKIN }}">{{ SMUDESA::SANGAT_MISKIN }}</option>
                                  <option value="{{ SMUDESA::BELUM_INPUT_DATA }}">{{ SMUDESA::BELUM_INPUT_DATA }}</option>
                                </select>
                              </div>
                            </div>
                            <div class="row" style="margin-top: 15px">
                                <div class="col-md-12 text-right">
                                    <button type="button" class="btn btn-secondary" onclick="reset_data()"> Reset </button>
                                    <button type="button" class="btn btn-primary" onclick="filter_data()"> FILTER </button>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-striped table-hover" id="tblData" style="width:100%;">
                              <thead>
                                <tr>
                                    <th>Provinsi</th>
                                    <th>Kabupaten</th>
                                    {{-- <th>Kecamatan</th> --}}
                                    <th>Kode</th>
                                    <th>NIK</th>
                                    <th>No KK</th>
                                    <th>Nama Lengkap</th>
                                    <th>Skor</th>
                                    <th>Status</th>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                        </div>
                    </div>
                    {{-- <div class="tab-pane fade" id="profile2" role="tabpanel" aria-labelledby="profile-tab2">
                        B
                    </div>
                    <div class="tab-pane fade" id="contact2" role="tabpanel" aria-labelledby="contact-tab2">
                        C
                    </div>
                    <div class="tab-pane fade" id="contact3" role="tabpanel" aria-labelledby="contact-tab3">
                        D
                    </div>
                    <div class="tab-pane fade" id="contact4" role="tabpanel" aria-labelledby="contact-tab4">
                        E
                    </div>
                    <div class="tab-pane fade" id="contact5" role="tabpanel" aria-labelledby="contact-tab5">
                        F
                    </div>
                    <div class="tab-pane fade" id="contact6" role="tabpanel" aria-labelledby="contact-tab6">
                        G
                    </div> --}}
                </div>
            </div>
          </div>
    </div>
</div>


@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $("#id_provinsi").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_provinsi') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kabupaten").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_kab_kota_by_provinsi') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        provinsi_id: $("#id_provinsi").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    });

    function filter_data()
    {
        var id_provinsi = $("#id_provinsi").val();
        var id_kabupaten = $("#id_kabupaten").val();
        var status = $("#status").val();
        generate_data(id_provinsi, id_kabupaten, status)
    }

    function reset_data()
    {
        $("#id_provinsi").val("").trigger("change");
        $("#id_kabupaten").val("").trigger("change");
        $("#status").val("0").trigger("change");
        filter_data()
    }

    function generate_data(id_provinsi, id_kabupaten, status)
    {
        $("#tblData").DataTable({
            destroy: true,
            processing: true,
            serverSide: true,
            ajax: "{{ url('dukcapil/get-data') }}?id_provinsi="+id_provinsi+"&id_kabupaten="+id_kabupaten+"&status="+status,
            "columns": [
                { data: 'provinsi', name: 'provinsi' },
                { data: 'kabupaten', name: 'kabupaten' },
                // { data: 'kecamatan.name', name: 'kecamatan.name' },
                { data: 'code', name: 'code' },
                { data: 'nik', name: 'nik' },
                { data: 'no_kk', name: 'no_kk' },
                { data: 'nama_lengkap', name: 'nama_lengkap' },
                { data: 'skor', name: 'skor' },
                { data: 'status', name: 'status' },
                // { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
            ]
        });
    }

    generate_data("", "", 0);
</script>
@endsection
