@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Dokumen Pendukung</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Detail Indikator</a></div>
      <div class="breadcrumb-item active"><a href="#">Dokumen Pendukung</a></div>
    </div>
</div>
<div class="card card-primary">
  <div class="card-header">
    <h4>Dokumen Pendukung</h4>
  </div>
  <div class="card-body">
      <div class="row">
          {{-- <div class="col-md-4">
              <label>Tahun</label>
              <div class="row col-md-12">
                <input type="hidden" value="{{$dukcapil->id}}" id="id_dukcapil">
                <select id="tahun" class="form-control select2" onchange="get_data_indikator()">
                    @for ($i = 0; $i < count($tahun); $i++)
                    <option value="{{ $tahun[$i] }}" {{$selected_tahun == $tahun[$i] ? "selected" : ""}}>{{ $tahun[$i] }}</option>
                    @endfor
                </select>
              </div>
          </div> --}}
          <div class="col-md-12">
            <a href="{{ $redirect }}" class="btn btn-info text-white">Kembali</a>
            <button data-toggle="modal" data-target="#modalParameter" onclick="bersih()" class="btn btn-success text-white"><i class="fas fa-upload"></i> Upload Dokumen</button>

          </div>
      </div>
    <hr>
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>#</th>
                {{-- @if($indikator->label_surat == 1)
                <th>Tanggal</th>
                <th>Nomor</th>
                @endif --}}
                <th>Tanggal</th>
                <th>Nomor</th>
                <th>Tentang</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php $no = 1; ?>
            @foreach($dokumen as $d)
            <tr>
                <td>{{$no++}}</td>
                {{-- @if($indikator->label_surat == 1)
                <td>{{$d->tanggal}}</td>
                <td>{{$d->nomor}}</td>
                @endif --}}
                <td>{{$d->tanggal}}</td>
                <td>{{$d->nomor}}</td>
                <td>{{$d->tentang}}</td>
                <td>
                    <button data-toggle="modal" data-target="#modalParameter" onclick="edit({{$d->id}})" class="btn btn-primary btn-sm text-white"><i class="fas fa-pencil-alt"></i> Edit</button>
                    <a href="{{ url('dukcapil/dokumen_pendukung/download/'.$d->id) }}" target="_blank" class="btn btn-success btn-sm text-white"><i class="fas fa-file-download"></i> Download</a>
                    <a onclick="return confirm('Apakah yakin dokumen akan dihapus?')" href="{{ url('dukcapil/dokumen_pendukung/hapus/'.$d->id) }}" class="btn btn-danger btn-sm text-white"><i class="fas fa-trash-alt"></i> Hapus</a>

                </td>
            </tr>
            @endforeach
          </tbody>
        </table>
    </div>
  </div>
</div>

@endsection

@section('modal')
<div class="modal fade" id="modalParameter" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" data-backdrop="static" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Upload Data Pendukung</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="POST" action="{{ url('dukcapil/simpan_dokumen_pendukung') }}" enctype="multipart/form-data">
                <div class="modal-body">
                    @csrf
                    <input type="hidden" name="id_indikator" value="{{$indikator->id}}">
                    <input type="hidden" name="id_dukcapil" value="{{$dukcapil->id}}">
                    <input type="hidden" name="id" id="id">
                    {{--<input type="hidden" name="tahun" value="{{$tahun}}">--}}
                    {{--@if($indikator->label_surat == 1)
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Nomor Surat/Dokumen</label>
                        <input type="text" class="form-control" name="nomor" id="nomor" required>
                    </div>
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Tanggal</label>
                        <input type="date" class="form-control" name="tanggal" id="tanggal" required>
                    </div>
                    @endif --}}
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Nomor Surat/Dokumen</label>
                        <input type="text" class="form-control" name="nomor" id="nomor" required>
                    </div>
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Tanggal</label>
                        <input type="date" class="form-control" name="tanggal" id="tanggal" required>
                    </div>

                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Tentang</label>
                        {{-- <input type="text" class="form-control" name="tentang" required> --}}
                        <textarea name="tentang" id="tentang" class="form-control" required></textarea>
                    </div>

                    @if($indikator->dokumen == "all")
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Dokumen</label><br>
                        <input type="file" accept=".pdf,.doc,.docx,.xls,.xlsx,.jpg,.jpeg,.png" name="dokumen" id="dokumen" required>
                    </div>
                    @elseif($indikator->dokumen == "pdf")
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Dokumen</label><br>
                        <input type="file" accept=".pdf" name="dokumen" id="dokumen" required>
                    </div>
                    @elseif($indikator->dokumen == "word")
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Dokumen</label><br>
                        <input type="file" accept=".doc,.docx" name="dokumen" id="dokumen" required>
                    </div>
                    @elseif($indikator->dokumen == "excel")
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Dokumen</label><br>
                        <input type="file" accept=".xls,.xlsx" name="dokumen" id="dokumen" required>
                    </div>
                    @elseif($indikator->dokumen == "image")
                    <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">Dokumen</label><br>
                        <input type="file" accept=".jpg,.jpeg,.png" name="dokumen" id="dokumen" required>
                    </div>
                    @endif
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-success">Upload</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script>
    $("#tblData").DataTable();

    function edit(id)
    {
        $.get("{{ url('dukcapil/dokumen_pendukung/edit') }}/"+id, function(result){
            $("#id").val(result.id);
            $("#nomor").val(result.nomor);
            $("#tanggal").val(result.tanggal);
            $("#tentang").val(result.tentang);

            $("#dokumen").attr('required', false);
        });
    }

    function bersih()
    {
        $("#id").val("");
        $("#nomor").val("");
        $("#tanggal").val("");
        $("#tentang").val("");
        $("#dokumen").val("");

        $("#dokumen").attr('required', true);
    }
</script>
@endsection
