@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
<style>
    .hidden{
        visibility: collapse;
    }
</style>
@endsection

@section('isi')
<div class="section-header">
    <h1>Indikator</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Indikator</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4></h4>

    <div class="card-header-action">
        <a href="#" data-target="#modal-tambah" data-toggle="modal" class="btn btn-success text-white">
            <i class="fa fa-download" aria-hidden="true"></i> Import data masyarakat
        </a>
        <a href="{{ url('dukcapil/tambah') }}" class="btn btn-primary">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah data masyarakat
        </a>
    </div>
  </div>
  <div class="card-body">
    <div class="form-group replyBox m-t-20">
        
        <div class="row">
            <div class="col-md-4">
                <label>Pilih Provinsi</label>
                <select class="form-control select2" name="id_provinsi" id="id_provinsi" style="width: 100%">
                    <option value="">-- Silakan pilih --</option>
                </select>
            </div> 
            <div class="col-md-4">
                <label>Pilih Kabupaten</label>
                <select class="form-control select2" name="id_kabupaten" id="id_kabupaten" style="width: 100%">
                    <option value="">-- Silakan pilih --</option>
                </select>
            </div>  
            <div class="col-md-4">
                <label>Status</label>
                <select class="form-control" name="status" id="status" style="width: 100%">
                    <option value="0">Semua</option>
                    <option value="{{ SMUDESA::TIDAK_MISKIN }}">{{ SMUDESA::TIDAK_MISKIN }}</option>
                    <option value="{{ SMUDESA::RENTAN_MISKIN }}">{{ SMUDESA::RENTAN_MISKIN }}</option>
                    <option value="{{ SMUDESA::HAMPIR_MISKIN }}">{{ SMUDESA::HAMPIR_MISKIN }}</option>
                    <option value="{{ SMUDESA::MISKIN }}">{{ SMUDESA::MISKIN }}</option>
                    <option value="{{ SMUDESA::SANGAT_MISKIN }}">{{ SMUDESA::SANGAT_MISKIN }}</option>
                    <option value="{{ SMUDESA::BELUM_INPUT_DATA }}">{{ SMUDESA::BELUM_INPUT_DATA }}</option>
                </select>
            </div> 
        </div>  
        <div class="row" style="margin-top: 15px">
            <div class="col-md-12 text-right">
                <button type="button" class="btn btn-secondary" onclick="reset_data()"> Reset </button>
                <button type="button" class="btn btn-success" onclick="export_data()"> Export </button>
                <button type="button" class="btn btn-primary" onclick="filter_data()"> FILTER </button>
            </div>  
        </div>             
    </div>

    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>Provinsi</th>
                <th>Kabupaten</th>
                {{-- <th>Kecamatan</th> --}}
                <th>Kode</th>
                <th>NIK</th>
                <th>No KK</th>
                <th>Nama Lengkap</th>
                <th>Skor</th>
                <th>Status</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Import data masyarakat</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" id="frm_data" action="{{ url('dukcapil/import') }}" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="alert alert-info">
                        1. Download template terlebih dahulu <br>
                        2. Isi data sesuai dengan template yang sudah disediakan <br>
                        3. Upload template yang sudah diisi <br>
                        4. Klik tombol Import <br>
                    </div>
                    <div class="form-group"> 
                        <div class="row">
                            <label class="col-md-3">Download template</label>
                            <div class="col-md-9"> 
                                <a href="{{ asset('template/template_export.xlsx') }}" class="btn btn-success text-white">
                                    <i class="fa fa-download" aria-hidden="true"></i> Template import
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="form-group"> 
                        <div class="row">
                            <label class="col-md-3">File</label>
                            <div class="col-md-9"> 
                                <input type="file" name="file" required class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">IMPORT</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script>

    function edit_data(id)
    {
        var url = "{{url('admin/provinsi')}}/"+id+"/edit";

        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id").val(data.id);
                $("#name").val(data.name);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id").val("");
        $("#name").val("");
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "{{ url('dukcapil') }}/"+id+"/hapus",
                    success: function(data){
                        table_data.ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        table_data.ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

    $(document).ready(function() {
        $("#id_provinsi").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_provinsi') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kabupaten").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_kab_kota_by_provinsi') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        provinsi_id: $("#id_provinsi").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    });

    function filter_data()
    {
        var id_provinsi = $("#id_provinsi").val();
        var id_kabupaten = $("#id_kabupaten").val();
        var status = $("#status").val();
        generate_data(id_provinsi, id_kabupaten, status)
    }

    function reset_data()
    {
        $("#id_provinsi").val("").trigger("change");
        $("#id_kabupaten").val("").trigger("change");
        $("#status").val("0").trigger("change");
        filter_data()
    }

    function generate_data(id_provinsi, id_kabupaten, status)
    {
        $("#tblData").DataTable({
            destroy: true,
            processing: true,
            serverSide: true,
            ajax: "{{ url('dukcapil/get-data') }}?id_provinsi="+id_provinsi+"&id_kabupaten="+id_kabupaten+"&status="+status,
            "columns": [
                { data: 'provinsi', name: 'provinsi' },
                { data: 'kabupaten', name: 'kabupaten' },
                // { data: 'kecamatan.name', name: 'kecamatan.name' },
                { data: 'code', name: 'code' },
                { data: 'nik', name: 'nik' },
                { data: 'no_kk', name: 'no_kk' },
                { data: 'nama_lengkap', name: 'nama_lengkap' },
                { data: 'skor', name: 'skor' },
                { data: 'status', name: 'status' },
                { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
            ]
        });
    }

    generate_data("", "", 0);

    function export_data()
    {
        var id_provinsi = $("#id_provinsi").val();
        var id_kabupaten = $("#id_kabupaten").val();
        var status = $("#status").val();

        window.location.href = "{{ url('dukcapil/export') }}?id_provinsi="+id_provinsi+"&id_kabupaten="+id_kabupaten+"&status="+status;
    }
</script>
@endsection
