@extends('front_end.template_new')
@section('isi')
<!-- Parallax Effect -->
<script type="text/javascript">$(document).ready(function(){$('#parallax-pagetitle').parallax("50%", -0.55);});</script>

<section class="parallax-effect">
  <div id="parallax-pagetitle" style="background-image: url({{ asset('assets/start_hotel/images/parallax/1900x911.gif') }});">
    <div class="color-overlay"> 
      <!-- Page title -->
      <div class="container">
        <div class="row">
          <div class="col-sm-12">
            <ol class="breadcrumb">
              <li><a href="index.html">Home</a></li>
              <li><a href="{{ url('/front/wisata/detail/'.$paket->id_wisata) }}">Daftar Paket</a></li>
              <li class="active">Detail Paket</li>
            </ol>
            <h1>{{ $paket->nama }}</h1>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<div class="container mt50">
    <div class="row"> 
      <!-- Slider -->
      <section class="standard-slider room-slider">
        <div class="col-sm-12 col-md-8">
          <div id="owl-standard" class="owl-carousel">
            @foreach ($paket_foto as $item)
            <div class="item"> <a href="{{ asset('gambar_paket/'.$item->id.'/'.$item->foto)}}" data-rel="prettyPhoto[gallery1]"><img src="{{ asset('gambar_paket/'.$item->id.'/'.$item->foto)}}" alt="{{$item->nama}}" class="img-responsive"></a> </div>
            @endforeach
          </div>
        </div>
      </section>
      
      <!-- Reservation form -->
      <section id="reservation-form" class="mt50 clearfix">
        <div class="col-sm-12 col-md-4">
          <form class="reservation-vertical clearfix" role="form" method="post" action="php/reservation.php" name="reservationform" id="reservationform">
            <h2 class="lined-heading"><span>Reservation</span></h2>
            <div class="price">
              {{-- <h4>Double Room</h4> --}}
              Rp. {{number_format($paket->harga)}}<span> per orang</span></div>
            <div id="message"></div>
            <!-- Error message display -->
            <div class="form-group">
              <label for="email" accesskey="E">E-mail</label>
              <input name="email" type="text" id="email" value="" class="form-control" placeholder="Please enter your E-mail"/>
            </div>
            <div class="form-group">
                <label for="email" accesskey="J">Jumlah Orang</label>
                <input name="jumlah_orang" type="number" id="jumlah_orang" value="" class="form-control"/>
            </div>
            
            <button type="submit" class="btn btn-primary btn-block">Book Now</button>
          </form>
        </div>
      </section>
      
      <!-- Room Content -->
      <section>
        <div class="container">
          <div class="row">
            {{-- <div class="col-sm-7 mt50">
              <h2 class="lined-heading"><span>Room Details</span></h2>
              <h3 class="mt50">Table overview</h3>
              <table class="table table-striped mt30">
                <tbody>
                  <tr>
                    <td><i class="fa fa-check-circle"></i> Double Bed</td>
                    <td><i class="fa fa-check-circle"></i> Free Internet</td>
                    <td><i class="fa fa-check-circle"></i> Free Newspaper</td>
                  </tr>
                  <tr>
                    <td><i class="fa fa-check-circle"></i> 60 square meter</td>
                    <td><i class="fa fa-check-circle"></i> Beach view</td>
                    <td><i class="fa fa-check-circle"></i> 2 persons</td>
                  </tr>
                  <tr>
                    <td><i class="fa fa-check-circle"></i> Double Bed</td>
                    <td><i class="fa fa-check-circle"></i> Free Internet</td>
                    <td><i class="fa fa-check-circle"></i> Breakfast included</td>
                  </tr>
                  <tr>
                    <td><i class="fa fa-check-circle"></i> Private Balcony</td>
                    <td><i class="fa fa-check-circle"></i> Flat Screen TV</td>
                    <td><i class="fa fa-check-circle"></i> Jacuzzi</td>
                  </tr>
                </tbody>
              </table>
              <p class="mt50">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc ligula nibh, cursus id euismod non, scelerisque nec nibh. Nam semper, ligula a rhoncus fermentum, libero lacus vulputate felis, id auctor mauris urna quis diam.</p>
            </div> --}}
            <div class="col-sm-12 mt50">
              <h2 class="lined-heading"><span>Overview</span></h2>
              
              <!-- Nav tabs -->
              <ul class="nav nav-tabs">
                {{-- <li class="active"><a href="#overview" data-toggle="tab">Tentang</a></li> --}}
                <li class="active"><a href="#facilities" data-toggle="tab">Facilities</a></li>
              </ul>
              <!-- Tab panes -->
              <div class="tab-content">
                {{-- <div class="tab-pane fade in active" id="overview">
                  {!! $room->tentang !!}
                </div> --}}
                <div class="tab-pane fade in active" id="facilities">{!! $paket->fasilitas !!}</div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
</div>
@endsection