@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/cssCustom/jquery.treeview.css') }}" />
@endsection

@section('isi')
<div class="section-header">
    <h1>Hak Akses</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Pengaturan</a></div>
      <div class="breadcrumb-item active"><a href="{{ url('admin/hak-akses') }}">Hak Akses</a></div>
      <div class="breadcrumb-item active"><a href="#">Edit</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Edit Data Hak Akses</h4>
  </div>
  <div class="card-body">
    <form action='update' method="POST">
        {{csrf_field()}}
        <div class="form-group">
            <label>Hak Akses</label>
            <input type="text" name="nama_hak_akses" class="form-control" value="{{$hak_akses->nama_hak_akses}}" required>
        </div>  
        <div class="form-group">
            <label>Hak Akses Menu</label>
            {!! $tree !!}               
        </div>                       
        <input type="submit" class="btn btn-primary" value="Update">
        <a href="{{ url('admin/hak-akses') }}" class="btn btn-warning text-white">Cancel</a>
    </form>
  </div>
</div>
@endsection

@section('modal')
@endsection

@section('js')
<script type="text/javascript" src="{{ asset('assets/jsCustom/jquery-checktree.js') }}"></script>
<script type="text/javascript" src="{{ asset('assets/jsCustom/jquery.treeview.js') }}"></script>
<script type="text/javascript">
    $('#tree').checktree();
  
    $(document).ready(function(){
      
      // first example
      $(".navigations").treeview({
        collapsed: true,
        persist: "location",
        control: "#treecontrol"
      });
  
    });
  </script>
@endsection