@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Indikator</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Master Data</a></div>
      <div class="breadcrumb-item active"><a href="#">Indikator</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Indikator</h4>

    <div class="card-header-action">
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </button>
    </div>
  </div>
  <div class="card-body">
    {{-- <div class="alert alert-info">
        <b>Penting</b> : <br> Total Persentase harus 100%
    </div> --}}
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th hidden>ID</th>
                <th>Variabel</th>
                <th>Indikator</th>
                <th>Penjelasan</th>
                <th>Bobot</th>
                <th>Jenis</th>
                <!-- <th>Type</th>
                <th>Label Surat</th> -->
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')
<div class="modal fade" id="modal-tambah" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Indikator</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" id="frm_data">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Variabel</label>
                                <!-- onchange="get_info_variabel()" -->
                                <select name="id_variabel" id="id_variabel" class="form-control select2" required style="width: 100%" >
                                    <option value="">-- Pilih Variabel --</option>
                                    @foreach ($variabel as $item)
                                        <option value="{{ $item->id }}">{{ $item->nama }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12" id="divInfoVariabel" style="display: none">

                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Indikator</label>
                                <input type="text" class="form-control" name="name" id="name" required>
                                <input type="hidden" name="id" id="id">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Penjelasan</label>
                                <textarea name="penjelasan" id="penjelasan" class="form-control"></textarea>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">bobot</label>
                                <input type="text" class="form-control allownumericwithdecimal" name="bobot" id="bobot" required>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Dokumen</label>
                                <select class="form-control" name="dokumen" id="dokumen" required>
                                    <option value="" selected="">-- Pilih Dokumen --</option>
                                    <option value="all">Izinkan semua</option>
                                    <option value="pdf">Dokumen PDF</option>
                                    <option value="word">Dokumen Word</option>
                                    <option value="excel">Dokumen Excel</option>
                                    <option value="image">Dokumen Gambar (.jpg, .jpeg, .png)</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                            <!-- onchange="tampilkan()" -->
                                <label class="control-label">Jenis</label>
                                <select class="form-control" id="jenis" name="jenis" required="">
                                    <option value="" selected="">Choose...</option>
                                    <option value="Pilihan">Pilihan</option>
                                    <!-- <option value="Kuantitas">Kuantitas</option>
                                    <option value="Kualitas">Kualitas</option> -->
                                </select>
                            </div>
                        </div>
                        <!-- <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Type</label>
                                <select class="form-control" id="type" name="type" required="">
                                    <option value="" selected="">Choose...</option>
                                    <option value="Fungsional">Fungsional</option>
                                    <option value="Non Fungsional">Non Fungsional</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Label Surat</label>
                                <select class="form-control" id="label_surat" name="label_surat" required="">
                                    <option value="" selected="">Choose...</option>
                                    <option value="1">Ya</option>
                                    <option value="0">Tidak</option>
                                </select>
                            </div>
                        </div> -->
                        <div class="col-md-12" id="divPilihan" style="display: none;">
                        {{--<div class="form-group row">
                                <div class="col-md-6">
                                    <label class="form-label">Parameter 1 (nilai = 0)</label>
                                    <input type="text" class="form-control" name="param1" id="param1">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Parameter 2 (nilai = 1)</label>
                                    <input type="text" class="form-control" name="param2" id="param2">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label class="form-label">Parameter 3 (nilai = 2)</label>
                                    <input type="text" class="form-control" name="param3" id="param3">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Parameter 4 (nilai = 3)</label>
                                    <input type="text" class="form-control" name="param4" id="param4">
                                </div>
                            </div>
                             <div class="form-group">
                                <div class="col-md-6">
                                    <label class="form-label">Parameter 5 (nilai = 4)</label>
                                    <input type="text" class="form-control" name="param5" id="param5">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Parameter 6 (nilai = 5)</label>
                                    <input type="text" class="form-control" name="param6" id="param6">
                                </div>
                            </div> --}}
                        </div>
                        <div class="col-md-12" id="divKuantitas" style="display: none;">
                            <div class="form-group row">
                                <div class="col-md-12">
                                    <label class="form-label">Data Profil</label>
                                    <select class="form-select select2" name="id_profil" id="id_profil" style="width: 100%">
                                        <option value="" selected>Choose...</option>
                                        @foreach($profil as $p)
                                        <option value="{{$p->id}}">{{$p->nama}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label class="form-label">Parameter 1 (nilai = 0)</label>
                                    <input type="text" class="form-control allownumericwithdecimal" name="rawalparam1" placeholder="Range Awal Parameter 1" id="rawalparam1" step="any">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">&nbsp;</label>
                                    <input type="text" class="form-control allownumericwithdecimal" name="rakhirparam1" placeholder="Range Akhir Parameter 1" id="rakhirparam1" step="any">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label class="form-label">Parameter 2 (nilai = 1)</label>
                                    <input type="text" class="form-control allownumericwithdecimal" name="rawalparam2" placeholder="Range Awal Parameter 2" id="rawalparam2" step="any">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">&nbsp;</label>
                                    <input type="text" class="form-control allownumericwithdecimal" name="rakhirparam2" placeholder="Range Akhir Parameter 2" id="rakhirparam2" step="any">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label class="form-label">Parameter 3 (nilai = 2)</label>
                                    <input type="text" class="form-control allownumericwithdecimal" name="rawalparam3" placeholder="Range Awal Parameter 3" id="rawalparam3" step="any">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">&nbsp;</label>
                                    <input type="text" class="form-control allownumericwithdecimal" name="rakhirparam3" placeholder="Range Akhir Parameter 3" id="rakhirparam3" step="any">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label class="form-label">Parameter 4 (nilai = 3)</label>
                                    <input type="text" class="form-control allownumericwithdecimal" name="rawalparam4" placeholder="Range Awal Parameter 4" id="rawalparam4" step="any">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">&nbsp;</label>
                                    <input type="text" class="form-control allownumericwithdecimal" name="rakhirparam4" placeholder="Range Akhir Parameter 4" id="rakhirparam4" step="any">
                                </div>
                            </div>
                            {{-- <div class="form-group row">
                                <div class="col-md-6">
                                    <label class="form-label">Parameter 5 (nilai = 4)</label>
                                    <input type="number" class="form-control" name="rawalparam5" placeholder="Range Awal Parameter 5" id="rawalparam5" step="any">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label"></label>
                                    <input type="number" class="form-control mt-2" name="rakhirparam5" placeholder="Range Akhir Parameter 5" id="rakhirparam5" step="any">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label class="form-label">Parameter 6  (nilai = 5)</label>
                                    <input type="number" class="form-control" name="rawalparam6" placeholder="Range Awal Parameter 6" id="rawalparam6" step="any">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label"></label>
                                    <input type="number" class="form-control mt-2" name="rakhirparam6" placeholder="Range Akhir Parameter 6" id="rakhirparam6" step="any">
                                </div>
                            </div> --}}
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save changes</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>

<script>

    var table_data = $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ url('admin/indikator/get-data') }}",
        "columns": [
            { data: 'id', name: 'id', visible: false },
            { data: 'variabel', name: 'variabel' },
            { data: 'nama', name: 'nama' },
            { data: 'penjelasan', name: 'penjelasan' },
            { data: 'bobot', name: 'bobot' },
            { data: 'jenis', name: 'jenis' },
            // { data: 'type', name: 'type' },
            // { data: 'label_surat', name: 'label_surat' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    function edit_data(id)
    {
        var url = "{{url('admin/indikator')}}/"+id+"/edit";

        $.ajax({
            url: url,
            type: "GET",
            success: function(result){
                bersih();
                $("#id").val(result.indikator.id);
                $("#id_variabel").val(result.indikator.id_variabel).trigger("change");
                $("#name").val(result.indikator.nama);
                $("#bobot").val(result.indikator.bobot);
                $("#dokumen").val(result.indikator.dokumen);
                $("#jenis").val(result.indikator.jenis);
                $("#penjelasan").val(result.indikator.penjelasan);
                $("#type").val(result.indikator.type);
                $("#label_surat").val(result.indikator.label_surat);

                if(result.indikator.jenis == "Pilihan") //Pilihan
                {
                    $.each(result.parameter, function(i, v){
                        $("#param"+(i+1)).val(v.nama);
                    });
                }
                else if(result.indikator.jenis == "Kuantitas") // Kuantitas
                {
                    $("#idprofil").val(result.indikator.id_profil);
                    $.each(result.parameter_range, function(i, v){
                        $("#rawalparam"+(i+1)).val(v.range_start);
                        $("#rakhirparam"+(i+1)).val(v.range_end);
                    });
                }

                tampilkan();
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id").val("");
        $("#id_variabel").val("").trigger("change");
        $("#id_profil").val("").trigger("change");
        $("#name").val("");
        $("#bobot").val("");
        $("#dokumen").val("");
        $("#jenis").val("");
        $("#penjelasan").val("");
        $("#type").val("");
        $("#label_surat").val("").trigger("change");

        for(i=1; i <= 4; i++)
        {
            $("#param"+i).val("");
            $("#rawalparam"+i).val("");
            $("#rakhirparam"+i).val("");
        }

        tampilkan();
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "{{ url('admin/indikator') }}/"+id+"/hapus",
                    success: function(data){
                        table_data.ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        table_data.ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

    $("#frm_data").on("submit", function(e){
        e.preventDefault();
        $("#modal-tambah").modal('hide');
        $.ajax({
            type:"POST",
            url: "{{ url('admin/indikator/tambah') }}",
            data: $(this).serialize(),
            success: function(result){
                table_data.ajax.reload( null, false );

                if(result.issuccess)
                    swal("Sukses", result.message, "success");
                else
                    swal("Gagal", result.message, "error");
            }
        })
    });

    function get_info_variabel()
    {
        var id_variabel = $("#id_variabel").val();
        if(id_variabel.length != 0)
        {
            var url = "{{url('admin/indikator/get_info_variabel')}}/"+id_variabel;
            $("#divInfoVariabel").empty();
            $("#divInfoVariabel").show();
            $.ajax({
                url: url,
                type: "GET",
                success: function(data){
                    var html = '<div class="alert alert-secondary text-dark">\
                                    Persentase/Total bobot harus : '+data.persentase+' <br>\
                                    Total bobot Saat Ini : '+data.total_saat_ini+'\
                                </div>';

                    $("#divInfoVariabel").html(html);
                },
                error: function(data){
                    alert('Hubungi Admin !');
                    $("#divInfoVariabel").hide();
                }
            });
        }
        else
        {
            $("#divInfoVariabel").hide();
        }
    }

    function tampilkan() {
        // var jenis = $("#jenis").val();

        // if (jenis == "Pilihan") {
        //     document.getElementById("divPilihan").style.display = 'block';
        //     document.getElementById("divKuantitas").style.display = 'none';
        // } else if (jenis == 'Kuantitas') {
        //     document.getElementById("divKuantitas").style.display = 'block';
        //     document.getElementById("divPilihan").style.display = 'none';
        // } else {
        //     document.getElementById("divPilihan").style.display = 'none';
        //     document.getElementById("divKuantitas").style.display = 'none';

        // }
    }
    tampilkan();
</script>
@endsection
