@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Kecamatan</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Master Data</a></div>
      <div class="breadcrumb-item active"><a href="#">Kecamatan</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Kecamatan</h4>

    <div class="card-header-action">
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </button>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>Kabupaten/Kota</th>
                <th>Kecamatan</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')

@endsection

<div class="modal fade" id="modal-tambah" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Kecamatan</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" id="frm_data">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Kabupaten / Kota</label>
                                <select name="regency_id" id="regency_id" class="form-control select2" style="width: 100%" required>
                                    <option value="">-- Pilih Kabupaten / Kota --</option>
                                </select>
                                <input type="hidden" name="id" id="id">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Kecamatan</label>
                                <input type="text" class="form-control" name="name" id="name" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>

@section('js')
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script>
    var table_data = $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ url('admin/kecamatan/get-data') }}",
        "columns": [
            { data: 'kabupaten', name: 'districts.name' },
            { data: 'kecamatan', name: 'b.name' },
            { data: 'aksi', name: 'aksi', orderable: false, searchable: false}
        ]
    });

    function edit_data(id)
    {
        var url = "{{url('admin/kecamatan')}}/"+id+"/edit";

        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id").val(data.id);
                $("#regency_id").val(data.regency_id);
                $("#name").val(data.name);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id").val("");
        $("#name").val("");
        $("#regency_id").val("");
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "{{ url('admin/kecamatan') }}/"+id+"/hapus",
                    success: function(data){
                        table_data.ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        table_data.ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

    $("#frm_data").on("submit", function(e){
        e.preventDefault();
        $("#modal-tambah").modal('hide');
        $.ajax({
            type:"POST",
            url: "{{ url('admin/kecamatan/tambah') }}",
            data: $(this).serialize(),
            success: function(result){
                table_data.ajax.reload();

                if(result.issuccess)
                    swal("Sukses", result.message, "success");
                else
                    swal("Gagal", result.message, "error");
            }
        })
    });


</script>
<script>
    $(document).ready(function() {
        $("#regency_id").select2({
            dropdownParent: $("#modal-tambah"),
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_kabupaten') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    });

</script>
@endsection
