@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/summernote/summernote-bs4.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Kuisioner Ujian</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item"><a href="#">Master</a></div>
      <div class="breadcrumb-item"><a href="{{ url('/admin/kuisioner_ujian') }}">Kuisioner Ujian</a></div>
      <div class="breadcrumb-item active"><a href="#">Setting Ujian</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Program : {{ $program->nama }}</h4>

    <div class="card-header-action">
        <button type="button" class="btn btn-primary" data-toggle="modal" onclick="bersih()" data-target="#modal-tambah">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah Pertanyaan
        </button>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>No</th>
                <th>Pertanyaan</th>
                <th>Skor</th>
                <th>Jawaban Benar</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
                @php
                  $no = 1;
                  $skor = [];
                @endphp
                @foreach ($soal as $item)
                    @php
                        $jawaban = \DB::table('jawabans')->where('id_soal', $item->id)->where('jawaban_benar', 1)->first();
                        $skor[] = $item->skor;
                    @endphp
                    <tr>
                        <td>{{ $no }}</td>
                        <td>{!! $item->soal !!}</td>
                        <td>{{ $item->skor }}</td>
                        <td>
                            {!! $jawaban->jawaban ?? "" !!}
                        </td>
                        <td>
                            <a href="javascript:;" data-toggle="modal" data-target="#modal-tambah" onclick="edit_materi({{$item->id}})" class="btn btn-primary text-white" title="Edit">Edit</a>
                            <a href="javascript:;" onclick="hapus_materi({{$item->id}})" class="btn btn-danger text-white" title=Hapus">Hapus</a>
                        </td>
                    </tr>

                    @php
                        $no++;
                    @endphp
                @endforeach
          </tbody>
        </table>
        <br>
        <h5>Total Skor : {{ array_sum($skor)}} </h5>
    </div>
  </div>
</div>
@endsection

@section('modal')
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Pertanyaan</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{url('admin/kuisioner_ujian/tambah_soal')}}" method="post" id="frm_menu" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Pertanyaan</label>
                                {{-- <input type="text" class="form-control" name="soal" id="soal" required> --}}
                                <textarea name="soal" id="soal" class="summernote" required></textarea>
                                <input type="hidden" class="form-control" name="id_soal" id="id_soal">
                                <input type="hidden" class="form-control" name="id_program" id="id_program" value="{{ $id_program }}">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Skor</label>
                                <input type="number" class="form-control" name="skor" id="skor" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">File</label>
                                <input type="file" class="form-control" name="file" id="file">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Jawaban Benar</label>
                                <select name="jawaban_benar" id="jawaban_benar" class="form-control" required>
                                    <option value="0">A</option>
                                    <option value="1">B</option>
                                    <option value="2">C</option>
                                    <option value="3">D</option>
                                    <option value="4">E</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Pilihan Jawaban</label>
                            </div>
                        </div>

                        <div class="col-md-1">
                            <div class="form-group">
                                <label class="control-label">A :</label>
                            </div>
                        </div>
                        <div class="col-md-11">
                            <div class="form-group">
                                {{-- <input type="text" name="pilihan_jawaban0" id="pilihan_jawaban0" class="form-control"> --}}
                                <textarea name="pilihan_jawaban0" id="pilihan_jawaban0" class="summernote" required></textarea>
                            </div>
                        </div>

                        <div class="col-md-1">
                            <div class="form-group">
                                <label class="control-label">B :</label>
                            </div>
                        </div>
                        <div class="col-md-11">
                            <div class="form-group">
                                {{-- <input type="text" name="pilihan_jawaban1" id="pilihan_jawaban1" class="form-control" required> --}}
                                <textarea name="pilihan_jawaban1" id="pilihan_jawaban1" class="summernote" required></textarea>
                            </div>
                        </div>

                        <div class="col-md-1">
                            <div class="form-group">
                                <label class="control-label">C :</label>
                            </div>
                        </div>
                        <div class="col-md-11">
                            <div class="form-group">
                                {{-- <input type="text" name="pilihan_jawaban2" id="pilihan_jawaban2" class="form-control" required> --}}
                                <textarea name="pilihan_jawaban2" id="pilihan_jawaban2" class="summernote" required></textarea>
                            </div>
                        </div>

                        <div class="col-md-1">
                            <div class="form-group">
                                <label class="control-label">D :</label>
                            </div>
                        </div>
                        <div class="col-md-11">
                            <div class="form-group">
                                {{-- <input type="text" name="pilihan_jawaban3" id="pilihan_jawaban3" class="form-control" required> --}}
                                <textarea name="pilihan_jawaban3" id="pilihan_jawaban3" class="summernote" required></textarea>
                            </div>
                        </div>

                        <div class="col-md-1">
                            <div class="form-group">
                                <label class="control-label">E :</label>
                            </div>
                        </div>
                        <div class="col-md-11">
                            <div class="form-group">
                                {{-- <input type="text" name="pilihan_jawaban4" id="pilihan_jawaban4" class="form-control" required> --}}
                                <textarea name="pilihan_jawaban4" id="pilihan_jawaban4" class="summernote" required></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
<script src="{{ asset('assets/bundles/summernote/summernote-bs4.js') }}"></script>
<script>
    $("#tblData").DataTable();

    function edit_materi(id)
    {
        var url = "{{url('admin/kuisioner_ujian')}}/"+id+"/edit_soal";

        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id_soal").val(data.soal.id);
                $("#soal").summernote('code', data.soal.soal);
                // $("#soal").val(data.soal.soal);
                $("#skor").val(data.soal.skor);

                $.each(data.jawaban, function(i,l){

                    if(l.jawaban_benar == 1)
                    {
                        $("#jawaban_benar").val(i);
                    }
                    $("#pilihan_jawaban"+i).summernote('code', l.jawaban);
                    // $("#pilihan_jawaban"+i).val(l.jawaban);

                });
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function hapus_materi(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "{{ url('admin/kuisioner_ujian') }}/"+id+"/hapus_soal",
                    success: function(data){
                        swal({
                            title: "SUKSES",
                            text: "Data Terhapus!",
                            icon: "success"
                        }).then(() => {
                            location.reload();
                        });
                    },
                    error: function(data){
                        swal({
                            title: "GAGAL",
                            text: "Something went wrong!",
                            icon: "error"
                        });
                    }
                })
            }
        });
    }

    function bersih()
    {
        $("#id_soal").val("");
        // $("#soal").val("");
        $("#soal").summernote('code', "");
        $("#skor").val("");
        $("#jawaban_benar").val(0);
        // $("#pilihan_jawaban0").val("");
        // $("#pilihan_jawaban1").val("");
        // $("#pilihan_jawaban2").val("");
        // $("#pilihan_jawaban3").val("");
        // $("#pilihan_jawaban4").val("");
        $("#pilihan_jawaban0").summernote('code', "");
        $("#pilihan_jawaban1").summernote('code', "");
        $("#pilihan_jawaban2").summernote('code', "");
        $("#pilihan_jawaban3").summernote('code', "");
        $("#pilihan_jawaban4").summernote('code', "");
    }

    $(document).on("show.bs.modal", '.modal', function (event) {
        // console.log("Global show.bs.modal fire");
        var zIndex = 100000 + (10 * $(".modal:visible").length);
        $(this).css("z-index", zIndex);
        setTimeout(function () {
            $(".modal-backdrop").not(".modal-stack").first().css("z-index", zIndex - 1).addClass("modal-stack");
        }, 0);
    }).on("hidden.bs.modal", '.modal', function (event) {
        // console.log("Global hidden.bs.modal fire");
        $(".modal:visible").length && $("body").addClass("modal-open");
    });

    $(document).on('inserted.bs.tooltip', function (event) {
        // console.log("Global show.bs.tooltip fire");
        var zIndex = 100000 + (10 * $(".modal:visible").length);
        var tooltipId = $(event.target).attr("aria-describedby");
        $("#" + tooltipId).css("z-index", zIndex);
    });

    $(document).on('inserted.bs.popover', function (event) {
        // console.log("Global inserted.bs.popover fire");
        var zIndex = 100000 + (10 * $(".modal:visible").length);
        var popoverId = $(event.target).attr("aria-describedby");
        $("#" + popoverId).css("z-index", zIndex);
    });
</script>
@endsection
