@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Modul & Materi</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Modul & Materi</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Modul & Materi</h4>

    {{-- <div class="card-header-action">
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </button>
    </div> --}}
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>No</th>
                <th>Nama Program</th>
                <th>Jadwal</th>
                <th>Pengajar</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
                @php
                  $no = 1;
                @endphp
                @foreach ($program as $item)
                    <tr>
                        <td>{{ $no }}</td>
                        <td>{{ $item->nama }}</td>
                        <td>{{ date('d-M-Y', strtotime($item->mulai)). " s.d ". date('d-M-Y', strtotime($item->selesai)) }}</td>
                        <td>{{ $item->pengajar->nama ?? "-" }}</td>
                        <td>
                            @if (Auth::user()->id_hak_akses == 2)
                            <a href="{{ url('/admin/modul/lihat_materi/'.$item->id) }}" class="btn btn-success text-white" title="Detail Pembayaran">Lihat Materi</a>
                            @else
                            <a href="{{ url('/admin/modul/lihat_materi/'.$item->id) }}" class="btn btn-success text-white" title="Detail Pembayaran">Tambah & Lihat Materi</a>
                            @endif
                            
                        </td>
                    </tr>

                    @php
                        $no++;
                    @endphp
                @endforeach
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')
{{-- <div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Program</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{url('admin/program/tambah')}}" method="post" id="frm_menu">
                @csrf
                <div class="modal-body">
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Nama Program</label> 
                                <input type="text" class="form-control" name="nama" id="nama" required> 
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Ketua Pengajar</label> 
                                <select name="id_pengajar" class="form-control" id="id_pengajar"  required>
                                    <option value="">-- Pilih Ketuan Pengajar --</option>
                                    @foreach($pengajar as $v)
                                        <option value="{{$v->id}}">{{$v->nama}}</option>
                                    @endforeach
                                </select> 
                                <input type="hidden" name="id_program" id="id_program">
                            </div> 
                        </div>
                    </div>
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Harga (Rp)</label> 
                                <input type="number" class="form-control" name="harga" id="harga" required> 
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Kuota</label> 
                                <input type="number" class="form-control" name="kuota" id="kuota" required> 
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Jadwal Mulai</label> 
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </div>
                                    </div>
                                    <input type="text" data-date-format="yyyy-mm-dd" class="form-control datepicker" name="mulai" id="mulai" readonly required> 
                                </div>
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Jadwal Selesai</label> 
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </div>
                                    </div>
                                    <input type="text" data-date-format="yyyy-mm-dd" class="form-control datepicker" name="selesai" id="selesai" readonly required> 
                                </div>                                
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Tipe Program</label> 
                                <select name="tipe_program" class="form-control" id="tipe_program"  required>
                                    <option value="">-- Pilih Tipe Program --</option>
                                    <option value="Online">Online</option>
                                    <option value="Tatap Muka Langsung">Tatap Muka Langsung</option>
                                </select> 
                            </div> 
                        </div>
                    </div>
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Lokasi</label> 
                                <textarea name="lokasi" id="lokasi" class="form-control"></textarea>
                            </div> 
                        </div>
                    </div> 
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Status</label> 
                                <select name="status" class="form-control" id="status"  required>
                                    <option value="">-- Pilih Status --</option>
                                    <option value="Draft">Draft</option>
                                    <option value="Aktif">Aktif</option>
                                    <option value="Selesai">Selesai</option>
                                </select> 
                            </div> 
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div> --}}
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
<script>
    $("#tblData").DataTable();
</script>
@endsection