@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.css') }}">
<link rel="stylesheet" href="{{ asset('assets/bundles/bootstrap-timepicker/css/bootstrap-timepicker.min.css') }}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Pengajaran</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Pengajaran</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Pengajaran</h4>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>No</th>
                <th>Program</th>
                <th>Pengajar</th>
                <th>Materi</th>
                <th>Jadwal</th>
                <th>Pukul</th>
                <th>Link Zoom</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>
@endsection

@section('modal')
@endsection

@section('js')
<script src="{{ asset('assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
<script src="{{ asset('assets/bundles/bootstrap-timepicker/js/bootstrap-timepicker.min.js') }}"></script>
<script>
    $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ url('admin/pengajaran/get-data-pengajaran-saya') }}",
        "columns": [
            { data: 'DT_RowIndex', name: 'DT_RowIndex' },
            { data: 'nama_program', name: 'nama_program' },
            { data: 'pengajar', name: 'pengajar' },
            { data: 'nama_materi', name: 'nama_materi' },
            { data: 'tanggal', name: 'tanggal' },
            { data: 'pukul', name: 'pukul' },
            { data: 'link_zoom', name: 'link_zoom' }
        ]
    });
</script>
@endsection
