@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
@endsection

@section('isi')
<div class="section-header">
    {{-- <h1>Ajukan HAKI</h1> --}}
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Perbaikan HAKI</a></div>
    </div>
</div>
@if ($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
<form method="POST" action="{{ url('perbaikan-haki/update') }}" enctype="multipart/form-data">
    @csrf
    <div class="card card-primary">
        {{-- <div class="card-header">
            <h4>Edit Data Pengajuan</h4>
        </div> --}}
        <div class="card-body">

            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <label>Kode Pengajuan</label>
                        <input type="text" name="kode_pengajuan" class="form-control" value="{{$pengajuan_haki->kode_pengajuan}}" disabled>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label class="text-dark">Nomor Surat Pengajuan <i class="text-success">*Optional</i></label>
                <input type="text" name="no_surat_pengajuan" class="form-control" value="{{$pengajuan_haki->no_surat_pengajuan}}">
                <input type="hidden" name="id" class="form-control" value="{{$pengajuan_haki->id}}" required>
            </div>

            <div class="form-group">
                <label class="text-dark">Unggah Surat Pengajuan <i class="text-success">*(opsional | format: PDF/DOC/DOCX | maksimal 10 MB)</i></label>
                <input type="file" name="file_surat_pengajuan" class="form-control">
                @if ($pengajuan_haki->file_surat_pengajuan != null)
                    <a href="{{ asset('file_surat_pengajuan')."/".$pengajuan_haki->file_surat_pengajuan }}" target="_blank" title="Download Surat Pengajuan">
                        <i class="fa fa-download text-success"></i>
                    </a>
                @endif
            </div>

            <div class="form-group">
                <label class="text-dark">Jenis Kekayaan Intelektual (KI) yang Diajukan</label>
                <select name="id_jenis_haki" id="id_jenis_haki" class="form-control" required onchange="getFormbyJenisHaki()">
                    <option value="">-- Silakan Pilih --</option>
                    @foreach ($jenis_haki as $val)
                    <option value="{{$val->id}}" {{ $val->id == $pengajuan_haki->id_jenis_haki ? "selected" : ""}}>{{$val->nama}}</option>
                    @endforeach
                </select>
            </div>

            <i class="fa fa-spinner fa-spin" id="loadingSpin"></i>
            <div id="divJenisHaki"></div>

            <div class="form-group">
                <label class="text-dark">Satuan Kerja - Pengusul <i class="text-danger">*(wajib diisi)</i></label>
                <select name="id_satuan_kerja" class="form-control" required>
                    <option value="0">-- Silakan Pilih --</option>
                    @foreach ($satuan_kerja as $val)
                    <option value="{{$val->id}}" {{ $val->id == $pengajuan_haki->id_satuan_kerja ? "selected" : ""}}>{{$val->nama}}</option>
                    @endforeach
                </select>
            </div>

            <div class="form-group">
                <label class="text-dark">Judul Kekayaan Intelektual (KI) <i class="text-danger">*(wajib diisi)</i></label>
                <textarea name="judul_kekayaan_intelektual" class="form-control" required>{{$pengajuan_haki->judul_kekayaan_intelektual}}</textarea>
            </div>

            <div class="form-group">
                <label class="text-dark">Abstrak / Penjelasan Singkat KI <i class="text-danger">*(wajib diisi)</i></label>
                <textarea name="abstrak_kekayaan_intelektual" class="form-control" required>{{$pengajuan_haki->abstrak_kekayaan_intelektual}}</textarea>
            </div>

            <div class="form-group">
                <label class="text-dark">Nomor Kontak / HP <i class="text-danger">*(wajib diisi)</i></label>
                <input type="text" name="telp" class="form-control" required value="{{$pengajuan_haki->telp}}">
            </div>

            <div class="form-group">
                <label class="text-dark">Alamat Email yang Dapat Dihubungi <i class="text-danger">*(wajib diisi)</i></label>
                <input type="email" name="email" class="form-control" required value="{{$pengajuan_haki->email}}">
            </div>


            {{-- <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Email</label>
                        <input type="email" name="email" class="form-control" value="{{$pengajuan_haki->email}}" required>
                    </div>
                    <div class="col-md-6">
                        <label>No. Telepon</label>
                        <input type="text" name="telp" class="form-control" value="{{$pengajuan_haki->telp}}" required>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <label>Alamat</label>
                        <textarea name="alamat" class="form-control" required>{{$pengajuan_haki->alamat}}</textarea>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Nama Produk</label>
                        <input type="text" name="nama_produk" class="form-control" value="{{$pengajuan_haki->nama_produk}}" required>
                    </div>
                    <div class="col-md-6">
                        <label>Jenis Haki</label>
                        <select name="id_jenis_haki" class="form-control" required>
                            <option value="">-- Silakan Pilih --</option>
                            @foreach ($jenis_haki as $val)
                                <option value="{{$val->id}}" {{ $val->id == $pengajuan_haki->id_jenis_haki ? "selected" : ""}}>{{$val->nama}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label>Deskripsi Produk</label>
                        <textarea name="deskripsi_produk" class="form-control">{{$pengajuan_haki->deskripsi_produk}}</textarea>
                    </div>
                    <div class="col-md-6">
                        <label>Jumlah Produk</label>
                        <input type="number" name="jumlah_produk" class="form-control" value="{{$pengajuan_haki->jumlah_produk}}" required>
                    </div>
                </div>
            </div> --}}
        </div>
    </div>

    {{-- <div class="card card-primary">
        <div class="card-header">
            <h4>Upload Files</h4>
        </div>
        <div class="card-body">
            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>1. Etiket/Label Merek (jpg atau jpeg) atau dokumen pendukung produk HaKI (Ciptaan, Lagu, Buku): dalam bentuk pdf, mp4, mp3 atau Ketentuan Etiket/Label yang diupload adalah gambar dengan format JPEG dengan dimensi pixel minimal 300x300 dan maksimal 1024x1024.</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_etiket" class="form-control">
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>2. KTP dalam bentuk pdf</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_ktp" class="form-control">
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>3. Surat Pernyataan UMK/ Pelaku Ekonomi Kreatif Bermatera.</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_surat_pernyataan_umk" class="form-control">
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>4. Surat Rekomendasi UMK Binaan Dinas (Asli) dari Dinas Terkait (Dinas koperasi dan UMKM, Dinas Perindustrian dan Perdagangan atau Dinas Pariwisata dan Kebudayaan).</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_surat_rekomendasi_umk" class="form-control">
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-8">
                        <label>5. Tanda tangan pemohon dalam bentuk JPG atau JPEG</label>
                    </div>
                    <div class="col-md-4">
                        <input type="file" name="file_tanda_tangan" class="form-control">
                    </div>
                </div>
            </div>
        </div>
    </div> --}}

    <div class="card card-primary">
        <div class="card-header">
            <h4>Unggah File Deskripsi KI <i class="text-danger">*(wajib dilampirkan | format: PDF/DOC/DOCX | maksimal 10 MB)</i></h4><br>
            {{-- <small class="text-muted ms-2">
            Maksimal 5 file (PDF/DOC/DOCX, max 10MB)
            </small> --}}
        </div>
        <div class="card-body">
            @if($pengajuan_haki->file_pendukung()->count() > 0)
                <table class="table table-striped table-sm table-bordered">
                    <thead>
                    <tr>
                        <th>Judul File</th>
                        <th>Aksi</th>
                    </tr>
                    </thead>
                    <tbody>
                        @foreach ($pengajuan_haki->file_pendukung()->get() as $val)
                        <tr>
                            <td>{{$val->judul}}</td>
                            <td>
                                <a href="{{ asset('perbaikan/file_pendukung')."/".$val->file }}" target="_blank" title="Download">
                                    <i class="fa fa-download text-success"></i>
                                </a> |
                                <a href="#" onclick="hapus_file_pendukung('{{$val->file}}')" title="Hapus">
                                    <i class="fa fa-trash text-danger"></i>
                                </a>
                            </td>
                        </tr>
                        @endforeach

                    </tbody>
                </table>
            @endif
            <br>
            <div id="file-container">
                <!-- Item pertama -->
                <div class="form-group file-item">
                    <div class="row align-items-center">
                        <div class="col-md-4">
                            <input type="text"
                                   name="judul_file_pendukung[]"
                                   class="form-control"
                                   placeholder="Judul File (Wajib diisi)">
                        </div>

                        <div class="col-md-4">
                            <input type="file"
                                   name="file_pendukung[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx">
                            <small class="text-muted file-preview"></small>
                        </div>

                        <div class="col-md-2 text-danger file-error"></div>

                        <div class="col-md-2 text-end">
                            <button type="button"
                                    class="btn btn-danger btn-remove d-none">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group mt-3">
                <button type="button"
                        class="btn btn-danger"
                        id="btn-add-file">
                    <i class="fa fa-plus"></i> Tambah File Lain
                </button>
            </div>
        </div>
    </div>

    <div class="card card-primary">
        <div class="card-header">
          <h4>Kolaborator Internal <i class="text-danger">*(wajib diisi)</i></h4>
        </div>
        <div class="card-body">
            @if($pengajuan_haki->kolabolator()->where('jenis', 'Internal')->count() > 0)
                <table class="table table-striped table-sm table-bordered">
                    <thead>
                    <tr>
                        <th>Nama</th>
                        <th>Instansi</th>
                        <th>KTP</th>
                        <th>NPWP</th>
                        <th>Aksi</th>
                    </tr>
                    </thead>
                    <tbody>
                        @foreach ($pengajuan_haki->kolabolator()->where('jenis', 'Internal')->get() as $val)
                        <tr>
                            <td>{{$val->nama}}</td>
                            <td>{{$val->instansi}}</td>
                            <td>
                                <a href="{{ asset('perbaikan/file_ktp_kolabolator_Internal')."/".$val->file_ktp }}" target="_blank" title="Download">
                                    <i class="fa fa-download text-success"></i>
                                </a>
                            </td>
                            <td>
                                <a href="{{ asset('perbaikan/file_npwp_kolabolator_Internal')."/".$val->file_npwp }}" target="_blank" title="Download">
                                    <i class="fa fa-download text-success"></i>
                                </a>
                            </td>
                            <td>
                                <a href="#" onclick="hapus_file_kolabolator({{$val->id}},'Internal')" title="Hapus">
                                    <i class="fa fa-trash text-danger"></i>
                                </a>
                            </td>
                        </tr>
                        @endforeach

                    </tbody>
                </table>
            @endif
            <br>
            <div id="file-container-internal">
                <!-- Item pertama -->
                <div class="form-group file-item-internal">
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <label class="text-dark">Nama <i class="text-danger">*(wajib diisi)</i></label>
                            <input type="text" name="nama_kolabolator_internal[]" class="form-control file-input">
                        </div>
                        <div class="col-md-3">
                            <label class="text-dark">Instansi <i class="text-danger">*(wajib diisi)</i></label>
                            <input type="text" name="instansi_kolabolator_internal[]" class="form-control file-input">
                        </div>
                        <div class="col-md-2">
                            <label class="text-dark">KTP <i class="text-danger">*(wajib diisi)</i></label>
                            <input type="file"
                                   name="file_ktp_kolabolator_internal[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx,.jpg,.jpeg,.png"
                                   >
                        </div>
                        <div class="col-md-2">
                            <label class="text-dark">NPWP <i class="text-danger">*(wajib diisi)</i></label>
                            <input type="file"
                                   name="file_npwp_kolabolator_internal[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx,.jpg,.jpeg,.png"
                                   >
                        </div>

                        <div class="col-md-2 text-end">
                            <button type="button"
                                    class="btn btn-danger btn-remove-internal d-none">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group mt-3">
                <button type="button"
                        class="btn btn-danger"
                        id="btn-add-file-internal">
                    <i class="fa fa-plus"></i> Tambah
                </button>
            </div>
        </div>
    </div>

    <div class="card card-primary">
        <div class="card-header">
          <h4>Kolaborator Eksternal <i class="text-success">*(Jika ada)</i></h4>
        </div>
        <div class="card-body">
            @if($pengajuan_haki->kolabolator()->where('jenis', 'Eksternal')->count() > 0)
                <table class="table table-striped table-sm table-bordered">
                    <thead>
                    <tr>
                        <th>Nama</th>
                        <th>Instansi</th>
                        <th>KTP</th>
                        <th>NPWP</th>
                        <th>Aksi</th>
                    </tr>
                    </thead>
                    <tbody>
                        @foreach ($pengajuan_haki->kolabolator()->where('jenis', 'Eksternal')->get() as $val)
                        <tr>
                            <td>{{$val->nama}}</td>
                            <td>{{$val->instansi}}</td>
                            <td>
                                <a href="{{ asset('perbaikan/file_ktp_kolabolator_Eksternal')."/".$val->file_ktp }}" target="_blank" title="Download">
                                    <i class="fa fa-download text-success"></i>
                                </a>
                            </td>
                            <td>
                                <a href="{{ asset('perbaikan/file_npwp_kolabolator_Eksternal')."/".$val->file_npwp }}" target="_blank" title="Download">
                                    <i class="fa fa-download text-success"></i>
                                </a>
                            </td>
                            <td>
                                <a href="#" onclick="hapus_file_kolabolator({{$val->id}}, 'Eksternal')" title="Hapus">
                                    <i class="fa fa-trash text-danger"></i>
                                </a>
                            </td>
                        </tr>
                        @endforeach

                    </tbody>
                </table>
            @endif
            <br>
            <div id="file-container-eksternal">
                <!-- Item pertama -->
                <div class="form-group file-item-eksternal">
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <label class="text-dark">Nama</label>
                            <input type="text" name="nama_kolabolator_eksternal[]" class="form-control file-input">
                        </div>
                        <div class="col-md-3">
                            <label class="text-dark">Instansi</label>
                            <input type="text" name="instansi_kolabolator_eksternal[]" class="form-control file-input">
                        </div>
                        <div class="col-md-2">
                            <label class="text-dark">KTP</label>
                            <input type="file"
                                   name="file_ktp_kolabolator_eksternal[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                        </div>
                        <div class="col-md-2">
                            <label class="text-dark">NPWP</label>
                            <input type="file"
                                   name="file_npwp_kolabolator_eksternal[]"
                                   class="form-control file-input"
                                   accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                        </div>

                        <div class="col-md-2 text-end">
                            <button type="button"
                                    class="btn btn-danger btn-remove-eksternal d-none">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group mt-3">
                <button type="button"
                        class="btn btn-danger"
                        id="btn-add-file-eksternal">
                    <i class="fa fa-plus"></i> Tambah
                </button>
            </div>
        </div>
    </div>

    <div class="card card-primary">
        <div class="card-body text-center">
            <a href="{{ url('ajukan-haki') }}" class="btn btn-warning text-white btn-lg">KEMBALI</a>
            <button type="submit" class="btn btn-success btn-lg">UPDATE</button>
        </div>
    </div>
</form>
@endsection

@section('modal')
@endsection

@section('js')
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script src="{{ asset('assets/js/ajukan_haki.js')}}"></script>
<script>
function getFormbyJenisHaki()
{
    $("#divJenisHaki").empty();
    var id_jenis_haki = $("#id_jenis_haki").val();
    $("#loadingSpin").hide();
    if(id_jenis_haki != 0)
    {
        $("#loadingSpin").show();
        $.get("{{ url('get-perbaikan-by-jenis-haki') }}/" + id_jenis_haki + "/{{$pengajuan_haki->id}}", function(response) {
            $("#divJenisHaki").empty();
            $("#divJenisHaki").html(response);
            $("#loadingSpin").hide();
        });
    }
}
getFormbyJenisHaki();

function hapus_file_pendukung(filename)
{
    swal({
        title: "Anda yakin ?",
        text: "Akan menghapus file ini!",
        icon: "warning",
        buttons: true,
        dangerMode: true
    })
    .then((willDelete) => {
        if (willDelete) {
            $.ajax({
                type: "GET",
                url: "{{ url('perbaikan-haki/hapus-file-pendukung') }}/"+filename,
                success: function(data){
                    // swal("Terhapus!", data.message, "success");
                    window.location.reload();
                },
                error: function(data){
                    swal("GAGAL!", data.responseJSON.message, "error");
                }
            })
        }
    });
}

function hapus_file_kolabolator(id, path)
{
    swal({
        title: "Anda yakin ?",
        text: "Akan menghapus file ini!",
        icon: "warning",
        buttons: true,
        dangerMode: true
    })
    .then((willDelete) => {
        if (willDelete) {
            $.ajax({
                type: "GET",
                url: "{{ url('perbaikan-haki/hapus-file-kolabolator') }}/"+id+"/"+path,
                success: function(data){
                    // swal("Terhapus!", data.message, "success");
                    window.location.reload();
                },
                error: function(data){
                    swal("GAGAL!", data.responseJSON.message, "error");
                }
            })
        }
    });
}
</script>
@endsection
