@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
@endsection

@section('isi')
<div class="section-header">
    <h1>Perbaikan HAKI</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Perbaikan HAKI</a></div>
    </div>
</div>
<form method="POST" action="{{ url('perbaikan-haki/simpan') }}" enctype="multipart/form-data">
    @csrf
    <input type="hidden" name="id" value="0">
    <div class="card card-primary">
        {{-- <div class="card-header">
            <h4>Tambah Data</h4>
        </div> --}}
        <div class="card-body">

            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <label>Kode Pengajuan</label>
                        <select name="kode_pengajuan" id="kode_pengajuan" class="form-control" required>
                            <option value="">-- Silakan Pilih --</option>
                            @foreach ($pengajuan_haki as $val)
                            <option value="{{$val->kode_pengajuan}}">{{$val->kode_pengajuan}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card card-primary">
        <div class="card-body text-center">
            {{-- <a href="{{ url('perbaikan-haki') }}" class="btn btn-secondary">Kembali</a>
            <button type="submit" class="btn btn-success">LANJUT</button> --}}
            <a href="{{ url('perbaikan-haki') }}" class="btn btn-warning text-white btn-lg">KEMBALI</a>
            <button type="submit" class="btn btn-success btn-lg">LANJUT</button>
        </div>
    </div>
</form>
@endsection

@section('modal')
@endsection

@section('js')
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script>

function get_detail_pengajuan()
{
    var kode_pengajuan = $("#kode_pengajuan").val();

    var url = "{{url('perbaikan-haki/get-pengajuan-haki/')}}/"+kode_pengajuan;

    $.ajax({
        url: url,
        type: "GET",
        success: function(data){
            $("#nama_pemohon").val(data.nama_pemohon);
            $("#id_pengajuan_haki").val(data.id);
            $("#pekerjaan").val(data.pekerjaan);
            $("#email").val(data.email);
            $("#telp").val(data.telp);
            $("#alamat").val(data.alamat);
            $("#nama_produk").val(data.nama_produk);
            $("#id_jenis_haki").val(data.id_jenis_haki);
            $("#deskripsi_produk").val(data.deskripsi_produk);
            $("#jumlah_produk").val(data.jumlah_produk);
        },
        error: function(data){
            alert('Hubungi Admin !');
        }
    });
}
</script>
@endsection
