@extends('layout.template')

@section('css')
<link rel="stylesheet" href="{{ asset('leaflet/leaflet.css') }}"/>
<link rel="stylesheet" href="{{ asset('assets/bundles/select2/dist/css/select2.min.css')}}">
<!-- <style>
    #map { height: 100%; }
</style> -->
@endsection

@section('isi')
<div class="section-header">
    <h1>Peta</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="{{ url('/') }}">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Peta</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Filter</h4>
  </div>
  <div class="card-body">
    <div class="row">
        <div class="col-md-3">
            <label>Provinsi</label>
            <select name="id_provinsi" id="id_provinsi" class="form-control select2" required>
                <option value="">-- Silakan Pilih --</option>
            </select>
        </div>
        <div class="col-md-3">
            <label>Kabupaten/Kota</label>
            <select name="id_kabupaten" id="id_kabupaten" class="form-control select2" required>
                <option value="">-- Silakan Pilih --</option>
            </select>
        </div>
        <div class="col-md-3">
            <label>Kecamatan</label>
            <select name="id_kecamatan" id="id_kecamatan" class="form-control select2" required>
                <option value="">-- Silakan Pilih --</option>
            </select>
        </div>
        <div class="col-md-3">
            <label>Kelurahan</label>
            <select name="id_kelurahan" id="id_kelurahan" class="form-control select2" required>
                <option value="">-- Silakan Pilih --</option>
            </select>
        </div>
    </div>
  </div>
    <div class="card-footer bg-whitesmoke text-right">
        <button class="btn btn-secondary" onclick="resetFilter()">RESET</button>
        <button class="btn btn-primary" onclick="generateMap()">FILTER</button>
    </div>
</div>
<div class="card" id="preMap">
  <!-- <div class="card-header">
    <h4>Peta</h4>
  </div> -->
  <div class="card-body" id="map" style="height: 500px">
    <!-- <div class="row">
        <div class="col-md-12"><div id="map"></div></div>
    </div> -->
  </div>
</div>

@endsection

@section('modal')
@include('layout.setting_sidebar')
@endsection

@section('js')
<script src="{{ asset('leaflet/leaflet.js') }}"></script>
<script src="{{ asset('assets/bundles/select2/dist/js/select2.full.min.js')}}"></script>
<script>

    function generateMap()
    {
        var container = L.DomUtil.get('map');
        if(container != null){
            container._leaflet_id = null;
        }
        // map container initial
        const map = L.map('map');

        L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
            maxZoom: 19,
            attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
        }).addTo(map);

        //Add marker
        // var marker = L.marker([-6.83333,107.48333]).addTo(map);

        //Add Circle
        $.get("{{ url('peta/get_kordinat') }}?id_provinsi="+$("#id_provinsi").val()+"&id_kabupaten="+$("#id_kabupaten").val()+"&id_kecamatan="+$("#id_kecamatan").val()+"&id_kelurahan="+$("#id_kelurahan").val(), function(result){

            if(result.length > 0)
            {
                map.setView([result[0].latitude, result[0].longitude], 13)
            }
            else
            {
                map.setView([-4.40357956552482, 122.22876004207404], 4)
            }

            $.each(result, function(i, v){
                L.circle([v.latitude, v.longitude], {
                    color: 'blue',
                    fillColor: '#0000ff',
                    fillOpacity: 1,
                    radius: 50
                }).addTo(map).on('click', (event) => onMapClick(event, v.id));
            });
        });
    }
    generateMap();

    function resetFilter()
    {
        $("#id_provinsi").val("").trigger("change");
        $("#id_kabupaten").val("").trigger("change");
        $("#id_kecamatan").val("").trigger("change");
        $("#id_kelurahan").val("").trigger("change");

        generateMap();
    }
    //Add Polygon
    // var polygon = L.polygon([
    //     [-6.937183, 107.599764],
    //     [-6.937183, 107.589764],
    //     [-6.937183, 107.589764]
    // ]).addTo(map);

    //Popup
    // marker.bindPopup("<b>Hello world!</b><br>I am a popup.").openPopup();
    // circle.bindPopup("I am a circle.");
    // polygon.bindPopup("I am a polygon.");

    //standalone popup
    // var popup = L.popup()
    //     .setLatLng([51.513, -0.09])
    //     .setContent("I am a standalone popup.")
    //     .openOn(map);

    //Event
    // function onMapClick(e) {
    //     alert("You clicked the map at " + e.latlng);
    // }

    // map.on('click', onMapClick);

    // var popup = L.popup();

    function onMapClick(e,v) {
        // popup
        //     .setLatLng(e.latlng)
        //     .setContent("You clicked the map at " + e.latlng.toString())
        //     .openOn(map);
        $("#contentSidebarModal").empty();

        $.get("{{ url('peta/get_detail') }}/" + v, function(result){
            $("#contentSidebarModal").html(result);
            $(".settingSidebar-body").css("overflow", "auto");
            $("#ascrail2001").remove();
        });

        $(".settingSidebar").toggleClass("showSettingPanel")
    }

    $(".page-wrapper").on("click", function () {
        $(".settingSidebar").removeClass("showSettingPanel")
    });
    $(".btnClose").on('click', function(){
        $(".settingSidebar").removeClass("showSettingPanel")
    })

    $(document).ready(function() {
        $("#id_provinsi").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_provinsi') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kabupaten").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_kab_kota_by_provinsi') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        provinsi_id: $("#id_provinsi").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kecamatan").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_kecamatan_by_kab') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        kabupaten_id: $("#id_kabupaten").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });

        $("#id_kelurahan").select2({
            minimumInputLength: 2,
            // tags: [],
            multiple: false,
            ajax: {
                url: "{{ url('get_kelurahan_by_kecamatan') }}",
                dataType: 'json',
                type: "GET",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term,
                        kecamatan_id: $("#id_kecamatan").val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    });
</script>
@endsection
