<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\HakAksesController;
use App\Http\Controllers\ProgramController;
use App\Http\Controllers\FrontController;
use App\Http\Controllers\PendaftaranProgramController;
use App\Http\Controllers\PembayaranController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ModulController;
use App\Http\Controllers\PengajaranController;
use App\Http\Controllers\KuisionerUjianController;
use App\Http\Controllers\UjianController;
use App\Http\Controllers\LayananController;
use App\Http\Controllers\FormulirController;
use App\Http\Controllers\PetaController;
use App\Http\Controllers\DashboardController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('get-modal-content/{type}', [FrontController::class, 'GetModalContent']);
Route::get('get_kelurahan_by_kecamatan', [FrontController::class, 'get_kelurahan_by_kecamatan']);
Route::get('get_kecamatan', [FrontController::class, 'get_kecamatan']);
Route::get('get_provinsi', [FrontController::class, 'get_provinsi']);
Route::get('get_kab_kota_by_provinsi', [FrontController::class, 'get_kab_kota_by_provinsi']);
Route::get('get_kabupaten', [FrontController::class, 'get_kabupaten']);
Route::get('get_kecamatan_by_kab', [FrontController::class, 'get_kecamatan_by_kab']);
Route::post('daftar', [FrontController::class, 'daftar']);
require __DIR__.'/auth.php';
// Route::get('/', [FrontController::class, 'index']);
// Route::get('/tentang', [FrontController::class, 'tentang']);
// Route::get('/profile', [FrontController::class, 'profile']);
// Route::get('/mekanisme_pendaftaran', [FrontController::class, 'mekanisme_pendaftaran']);
// Route::get('/get-kab-kota/{provinsi_id}', [FrontController::class, 'get_kab_kota']);
// Route::get('/selesai_pembayaran', [PaymentController::class, 'selesai_pembayaran']);


// //Redirect dari midtrans
// Route::post('payments/notification', [PaymentController::class, 'notification']);
// Route::get('payments/completed', [PaymentController::class, 'completed']);
// Route::get('payments/failed', [PaymentController::class, 'failed']);
// Route::get('payments/unfinish', [PaymentController::class, 'unfinish']);

//Front End
Route::get('/', 'FrontEndController@index');
Route::get('front/hotel', 'FrontEndController@index_hotel');
Route::get('front/hotel/detail/{id}', 'FrontEndController@detail_hotel');
Route::get('front/hotel/booking_room/{id}', 'FrontEndController@booking_room');
Route::get('front/wisata', 'FrontEndController@index_wisata');
Route::get('front/wisata/detail/{id}', 'FrontEndController@detail_wisata');
Route::get('front/wisata/booking/{id}', 'FrontEndController@booking_wisata');

Route::middleware(['auth'])->group(function () {

    Route::get('dashboard', [DashboardController::class, 'index']);
    Route::get('layanans', [LayananController::class, 'index']);
    Route::get('layanans/get_form/{id_layanan}', [LayananController::class, 'get_form']);
    Route::post('layanans/daftar', [LayananController::class, 'daftar']);
    Route::get('layanans/status', [LayananController::class, 'status']);
    Route::get('layanans/status/get_data', [LayananController::class, 'get_data_status']);
    Route::get('layanans/status/detail/{id}', [LayananController::class, 'detail_status']);
    Route::get('layanans/status/edit/{id}', [LayananController::class, 'edit_status']);
    Route::get('layanans/status/hapus/{id}', [LayananController::class, 'hapus_status']);
    Route::post('layanans/status/update_status', [LayananController::class, 'update_status']);
    Route::post('layanans/status/revise_layanan', [LayananController::class, 'revise_layanan']);
    Route::get('formulirs', [FormulirController::class, 'index_formulir_user']);
    Route::get('peta', [PetaController::class, 'index']);
    Route::get('peta/get_kordinat', [PetaController::class, 'get_kordinat']);
    Route::get('peta/get_detail/{id_dukcapil}', [PetaController::class, 'get_detail']);
    Route::get('dukcapil', 'DukcapilController@index');
    Route::post('dukcapil/tambah', 'DukcapilController@tambah');
    Route::get('dukcapil/{id}/edit', 'DukcapilController@edit');
    Route::get('dukcapil/get-data', 'DukcapilController@get_data');
    Route::get('dukcapil/export', 'DukcapilController@export');
    Route::post('dukcapil/import', 'DukcapilController@import');
    Route::get('dukcapil/{id}/hapus', 'DukcapilController@hapus');
    Route::get('dukcapil/detail_indikator/{id}', 'DukcapilController@detail_indikator');
    Route::get('dukcapil/get_parameter', 'DukcapilController@get_parameter');
    Route::post('dukcapil/simpan_parameter', 'DukcapilController@simpan_parameter');
    Route::get('dukcapil/dokumen_pendukung', 'DukcapilController@dokumen_pendukung');
    Route::post('dukcapil/simpan_dokumen_pendukung', 'DukcapilController@simpan_dokumen_pendukung');
    Route::get('dukcapil/dokumen_pendukung/edit/{id}', 'DukcapilController@edit_dokumen_pendukung');
    Route::get('dukcapil/dokumen_pendukung/download/{id}', 'DukcapilController@download_dokumen_pendukung');
    Route::get('dukcapil/dokumen_pendukung/hapus/{id}', 'DukcapilController@hapus_dokumen_pendukung');
    Route::get('dukcapil/layanan/{id}', 'DukcapilController@layanan');
    Route::get('dukcapil/edit/{id}', 'DukcapilController@edit');
    Route::get('dukcapil/tambah', 'DukcapilController@tambah');
    Route::post('dukcapil/simpan', 'DukcapilController@simpan');

    //Ajukan HAKI
    Route::get('ajukan-haki', 'PengajuanHakiController@index');
    Route::get('ajukan-haki/tambah', 'PengajuanHakiController@tambah');
    Route::post('ajukan-haki/simpan', 'PengajuanHakiController@simpan');
    Route::get('ajukan-haki/{id}/edit', 'PengajuanHakiController@edit');
    Route::get('ajukan-haki/get-data', 'PengajuanHakiController@get_data');
    Route::get('ajukan-haki/{id}/hapus', 'PengajuanHakiController@hapus');
    Route::get('ajukan-haki/hapus-file-pendukung/{filename}', 'PengajuanHakiController@hapus_file_pendukung');
    Route::get('ajukan-haki/hapus-file-kolabolator/{id}/{path}', 'PengajuanHakiController@hapus_file_kolabolator');

    //Perbaikan HAKI
    Route::get('perbaikan-haki', 'PerbaikanHakiController@index');
    Route::get('perbaikan-haki/tambah', 'PerbaikanHakiController@tambah');
    Route::post('perbaikan-haki/simpan', 'PerbaikanHakiController@simpan');
    Route::post('perbaikan-haki/update', 'PerbaikanHakiController@update');
    Route::get('perbaikan-haki/{id}/edit', 'PerbaikanHakiController@edit');
    Route::get('perbaikan-haki/get-data', 'PerbaikanHakiController@get_data');
    Route::get('perbaikan-haki/{id}/hapus', 'PerbaikanHakiController@hapus');
    Route::get('perbaikan-haki/get-pengajuan-haki/{kode_pengajuan}', 'PerbaikanHakiController@get_pengajuan_haki');
    Route::get('perbaikan-haki/hapus-file-pendukung/{filename}', 'PerbaikanHakiController@hapus_file_pendukung');
    Route::get('perbaikan-haki/hapus-file-kolabolator/{id}/{path}', 'PerbaikanHakiController@hapus_file_kolabolator');

    //Bukti bayar
    Route::get('bukti-bayar', 'BuktiBayarController@index');
    Route::get('bukti-bayar/tambah', 'BuktiBayarController@tambah');
    Route::post('bukti-bayar/simpan', 'BuktiBayarController@simpan');
    Route::get('bukti-bayar/{id}/edit', 'BuktiBayarController@edit');
    Route::get('bukti-bayar/get-data', 'BuktiBayarController@get_data');
    Route::get('bukti-bayar/{id}/hapus', 'BuktiBayarController@hapus');
    Route::get('bukti-bayar/get-pengajuan-haki/{kode_pengajuan}', 'BuktiBayarController@get_pengajuan_haki');

    //Get Detail Form by Jenis HAKI
    Route::get('get-form-by-jenis-haki/{id_jenis_haki}/{id_pengajuan_haki}', 'PengajuanHakiController@get_form_by_jenis_haki');
    Route::get('get-perbaikan-by-jenis-haki/{id_jenis_haki}/{id_perbaikan_haki}', 'PerbaikanHakiController@get_form_by_jenis_haki');

    Route::prefix('admin')->group(function ($route) {

        $route->get('profile', [UserController::class, 'profile']);
        $route->post('profile/update', [UserController::class, 'update_profile']);
        $route->post('update_password', [UserController::class, 'update_password']);

        $route->get('menu', [MenuController::class, 'index']);
        $route->post('menu/tambah', [MenuController::class, 'tambah']);
        $route->get('menu/{id}/edit', [MenuController::class, 'edit']);
        $route->get('menu/get-data', [MenuController::class, 'get_data']);
        $route->get('menu/{id}/hapus', [MenuController::class, 'hapus']);

        $route->get('management-user', [UserController::class, 'index']);
        $route->post('management-user/tambah', [UserController::class, 'tambah']);
        $route->get('management-user/{id}/edit', [UserController::class, 'edit']);
        $route->get('management-user/get-data', [UserController::class, 'getData']);
        $route->get('management-user/{id}/hapus', [UserController::class, 'hapus']);

        $route->get('hak-akses', [HakAksesController::class, 'index']);
        $route->post('hak-akses/tambah', [HakAksesController::class, 'tambah']);
        $route->get('hak-akses/{id}/edit', [HakAksesController::class, 'edit']);
        $route->post('hak-akses/{id}/update', [HakAksesController::class, 'update']);

        $route->get('program', [ProgramController::class, 'index']);
        $route->get('program/program_saya', [ProgramController::class, 'index_program_saya']);
        $route->get('program/program_saya/get_partial_detail_program/{id_program}', [ProgramController::class, 'get_partial_detail_program_saya']);
        $route->post('program/program_saya/daftar', [ProgramController::class, 'daftar_program_saya']);
        $route->post('program/tambah', [ProgramController::class, 'tambah']);
        $route->get('program/{id}/edit', [ProgramController::class, 'edit']);
        $route->get('program/get-data', [ProgramController::class, 'get_data']);
        $route->get('program/get-data-program-saya', [ProgramController::class, 'get_data_program_saya']);
        $route->get('program/{id}/hapus', [ProgramController::class, 'hapus']);
        $route->get('program/program_saya/{id}/hapus', [ProgramController::class, 'hapus_program_saya']);

        $route->get('pendaftaran_program', [PendaftaranProgramController::class, 'index']);
        $route->post('pendaftaran_program/tambah', [PendaftaranProgramController::class, 'tambah']);
        $route->get('pendaftaran_program/{id}/edit', [PendaftaranProgramController::class, 'edit']);
        $route->get('pendaftaran_program/get-data', [PendaftaranProgramController::class, 'get_data']);
        $route->get('pendaftaran_program/{id}/hapus', [PendaftaranProgramController::class, 'hapus']);

        $route->get('pembayaran', [PembayaranController::class, 'index']);
        $route->get('pembayaran/get-data', [PembayaranController::class, 'get_data']);
        $route->get('pembayaran/{id}/edit_status', [PembayaranController::class, 'edit_status']);
        $route->get('pembayaran/detail/{id}', [PembayaranController::class, 'detail']);
        $route->post('pembayaran/ubah_status', [PembayaranController::class, 'ubah_status']);
        $route->get('payment/checkout/{id_pembayaran}', [PaymentController::class, 'checkout']);

        $route->get('modul', [ModulController::class, 'index']);
        $route->get('modul/lihat_materi/{id_program}', [ModulController::class, 'index_materi']);
        $route->get('modul/lihat_modul/{id_materi}', [ModulController::class, 'index_modul']);
        $route->get('modul/materi/{id_materi}/edit', [ModulController::class, 'edit_materi']);
        $route->post('modul/tambah_materi', [ModulController::class, 'tambah_materi']);
        $route->get('modul/hapus_materi/{id}', [ModulController::class, 'hapus_materi']);

        $route->post('modul/tambah', [ModulController::class, 'tambah_modul']);
        $route->get('modul/hapus/{id}', [ModulController::class, 'hapus_modul']);
        $route->get('modul/{id_modul}/edit', [ModulController::class, 'edit_modul']);
        $route->get('modul/download/{id_modul}', [ModulController::class, 'download_modul']);

        $route->get('pengajaran', [PengajaranController::class, 'index']);
        $route->get('pengajaran_saya', [PengajaranController::class, 'index_pengajaran_saya']);
        $route->post('pengajaran/tambah', [PengajaranController::class, 'tambah']);
        $route->get('pengajaran/{id}/edit', [PengajaranController::class, 'edit']);
        $route->get('pengajaran/get-data', [PengajaranController::class, 'get_data']);
        $route->get('pengajaran/get-data-pengajaran-saya', [PengajaranController::class, 'get_data_pengajaran_saya']);
        $route->get('pengajaran/{id}/hapus', [PengajaranController::class, 'hapus']);
        $route->get('pengajaran/get_materi/{id_program}', [PengajaranController::class, 'get_materi']);

        $route->get('kuisioner_ujian', [KuisionerUjianController::class, 'index']);
        $route->get('kuisioner_ujian/setting_ujian/{id_program}', [KuisionerUjianController::class, 'index_setting_ujian']);
        $route->post('kuisioner_ujian/tambah_soal', [KuisionerUjianController::class, 'tambah_soal']);
        $route->get('kuisioner_ujian/{id}/hapus_soal', [KuisionerUjianController::class, 'hapus_soal']);
        $route->get('kuisioner_ujian/{id}/edit_soal', [KuisionerUjianController::class, 'edit_soal']);

        $route->get('ujian', [UjianController::class, 'index']);
        $route->post('ujian/tambah', [UjianController::class, 'tambah']);
        $route->post('ujian/start', [UjianController::class, 'start']);
        $route->post('ujian/kirim', [UjianController::class, 'kirim']);
        $route->get('ujian/{id}/edit', [UjianController::class, 'edit']);
        $route->get('ujian/get-data', [UjianController::class, 'get_data']);
        $route->get('ujian/{id}/hapus', [UjianController::class, 'hapus']);
        $route->get('ujian/open/{id}', [UjianController::class, 'open']);
        $route->get('ujian/result/{id}/{id_user}', [UjianController::class, 'result']);
        $route->get('ujian/lihat_jawaban/{id}/{id_user}', [UjianController::class, 'lihat_jawaban']);

        $route->get('sertifikat', 'SertifikatController@index');
        $route->get('sertifikat/sertifikat_saya', 'SertifikatController@index_sertifikat_saya');
        $route->get('sertifikat/lihat_peserta/{id_program}', 'SertifikatController@lihat_peserta');
        $route->get('sertifikat/cetak/{id}', 'SertifikatController@generate_sertifikat');

        $route->get('pengajar', 'PengajarController@index');
        $route->post('pengajar/tambah', 'PengajarController@tambah');
        $route->get('pengajar/{id}/edit', 'PengajarController@edit');
        $route->get('pengajar/get-data', 'PengajarController@get_data');
        $route->get('pengajar/{id}/hapus', 'PengajarController@hapus');

        $route->get('provinsi', 'ProvinsiController@index');
        $route->post('provinsi/tambah', 'ProvinsiController@tambah');
        $route->get('provinsi/{id}/edit', 'ProvinsiController@edit');
        $route->get('provinsi/get-data', 'ProvinsiController@get_data');
        $route->get('provinsi/{id}/hapus', 'ProvinsiController@hapus');

        $route->get('kabupaten', 'KabupatenKotaController@index');
        $route->post('kabupaten/tambah', 'KabupatenKotaController@tambah');
        $route->get('kabupaten/{id}/edit', 'KabupatenKotaController@edit');
        $route->get('kabupaten/get-data', 'KabupatenKotaController@get_data');
        $route->get('kabupaten/{id}/hapus', 'KabupatenKotaController@hapus');

        $route->get('kecamatan', 'KecamatanController@index');
        $route->post('kecamatan/tambah', 'KecamatanController@tambah');
        $route->get('kecamatan/{id}/edit', 'KecamatanController@edit');
        $route->get('kecamatan/get-data', 'KecamatanController@get_data');
        $route->get('kecamatan/{id}/hapus', 'KecamatanController@hapus');

        $route->get('kelurahan', 'KelurahanController@index');
        $route->post('kelurahan/tambah', 'KelurahanController@tambah');
        $route->get('kelurahan/{id}/edit', 'KelurahanController@edit');
        $route->get('kelurahan/get-data', 'KelurahanController@get_data');
        $route->get('kelurahan/{id}/hapus', 'KelurahanController@hapus');

        $route->get('master/layanan', 'MasterLayananController@index');
        $route->get('master/layanan/tambah', 'MasterLayananController@tambah');
        $route->get('master/layanan/edit/{id}', 'MasterLayananController@edit');
        $route->get('master/layanan/hapus/{id}', 'MasterLayananController@hapus');
        $route->get('master/layanan/get_modal_field/{tipe}', 'MasterLayananController@get_modal_field');
        $route->post('master/layanan/simpan_update', 'MasterLayananController@simpan_update');
        $route->post('master/layanan/simpan_detail', 'MasterLayananController@simpan_detail');
        $route->get('master/layanan/get_data_kabupaten', 'MasterLayananController@get_data_kabupaten');
        $route->get('master/layanan/get_data_provinsi', 'MasterLayananController@get_data_provinsi');
        $route->get('master/layanan/index_detail', 'MasterLayananController@index_detail');

        $route->get('master_formulir', [FormulirController::class, 'index']);
        $route->post('master_formulir/tambah', [FormulirController::class, 'tambah']);
        $route->get('master_formulir/{id}/edit', [FormulirController::class, 'edit']);
        $route->get('master_formulir/get-data', [FormulirController::class, 'get_data']);
        $route->get('master_formulir/{id}/hapus', [FormulirController::class, 'hapus']);

        $route->get('variabel', 'VariabelController@index');
        $route->post('variabel/tambah', 'VariabelController@tambah');
        $route->get('variabel/{id}/edit', 'VariabelController@edit');
        $route->get('variabel/get-data', 'VariabelController@get_data');
        $route->get('variabel/{id}/hapus', 'VariabelController@hapus');
        $route->get('variabel/get_info_dimensi/{id_dimensi}', 'VariabelController@get_info_dimensi');
        $route->get('variabel/get_info_aspek/{id_aspek}', 'VariabelController@get_info_aspek');

        $route->get('aspek', 'AspekController@index');
        $route->post('aspek/tambah', 'AspekController@tambah');
        $route->get('aspek/{id}/edit', 'AspekController@edit');
        $route->get('aspek/get-data', 'AspekController@get_data');
        $route->get('aspek/{id}/hapus', 'AspekController@hapus');

        $route->get('indikator', 'IndikatorController@index');
        $route->post('indikator/tambah', 'IndikatorController@tambah');
        $route->get('indikator/{id}/edit', 'IndikatorController@edit');
        $route->get('indikator/get-data', 'IndikatorController@get_data');
        $route->get('indikator/{id}/hapus', 'IndikatorController@hapus');
        $route->get('indikator/get_info_variabel/{id_aspek}', 'IndikatorController@get_info_variabel');
        $route->get('indikator/parameter/{id_indikator}', 'IndikatorController@parameter');
        $route->post('indikator/parameter/simpan', 'IndikatorController@simpan_parameter');

        //Hotel
        $route->get('hotel', 'HotelController@index');
        $route->get('hotel/tambah', 'HotelController@tambah');
        $route->get('hotel/edit/{id}', 'HotelController@edit');
        $route->get('hotel/hapus/{id}', 'HotelController@hapus');
        $route->get('hotel/get_modal_field/{tipe}', 'HotelController@get_modal_field');
        $route->post('hotel/simpan_update', 'HotelController@simpan_update');
        $route->post('hotel/simpan_detail', 'HotelController@simpan_detail');
        $route->get('hotel/get_data_kabupaten', 'HotelController@get_data_kabupaten');
        $route->get('hotel/get_data_provinsi', 'HotelController@get_data_provinsi');
        $route->get('hotel/index_detail', 'HotelController@index_detail');
        $route->post('hotel/simpan_gambar', 'HotelController@simpan_gambar');
        $route->get('hotel/hapus_gambar/{id}', 'HotelController@hapus_gambar');
        $route->get('hotel/edit_kamar/{id}', 'HotelController@edit_kamar');
        $route->post('hotel/simpan_kamar', 'HotelController@simpan_kamar');
        $route->get('hotel/hapus_kamar/{id}', 'HotelController@hapus_kamar');
        $route->get('hotel/get_modal_foto_kamar/{id}', 'HotelController@get_modal_foto_kamar');
        $route->get('hotel/detail_kamar/{id}', 'HotelController@detail_kamar');
        $route->get('hotel/hapus_foto_kamar/{id}', 'HotelController@hapus_foto_kamar');
        $route->post('hotel/simpan_gambar_kamar', 'HotelController@simpan_gambar_kamar');


        //Wisata
        $route->get('wisata', 'WisataController@index');
        $route->get('wisata/tambah', 'WisataController@tambah');
        $route->get('wisata/edit/{id}', 'WisataController@edit');
        $route->get('wisata/hapus/{id}', 'WisataController@hapus');
        $route->get('wisata/get_modal_field/{tipe}', 'WisataController@get_modal_field');
        $route->post('wisata/simpan_update', 'WisataController@simpan_update');
        $route->post('wisata/simpan_detail', 'WisataController@simpan_detail');
        $route->get('wisata/get_data_kabupaten', 'WisataController@get_data_kabupaten');
        $route->get('wisata/get_data_provinsi', 'WisataController@get_data_provinsi');
        $route->get('wisata/index_detail', 'WisataController@index_detail');
        $route->post('wisata/simpan_gambar', 'WisataController@simpan_gambar');
        $route->get('wisata/hapus_gambar/{id}', 'WisataController@hapus_gambar');
        $route->get('wisata/edit_paket/{id}', 'WisataController@edit_paket');
        $route->post('wisata/simpan_paket', 'WisataController@simpan_paket');
        $route->get('wisata/hapus_paket/{id}', 'WisataController@hapus_paket');
        $route->get('wisata/get_modal_foto_paket/{id}', 'WisataController@get_modal_foto_paket');
        $route->get('wisata/detail_paket/{id}', 'WisataController@detail_paket');
        $route->get('wisata/hapus_foto_paket/{id}', 'WisataController@hapus_foto_paket');
        $route->post('wisata/simpan_gambar_paket', 'WisataController@simpan_gambar_paket');

        //Jenis Haki
        $route->get('jenis-haki', 'JenisHakiController@index');
        $route->post('jenis-haki/tambah', 'JenisHakiController@tambah');
        $route->get('jenis-haki/{id}/edit', 'JenisHakiController@edit');
        $route->get('jenis-haki/get-data', 'JenisHakiController@get_data');
        $route->get('jenis-haki/{id}/hapus', 'JenisHakiController@hapus');

        //Satuan Kerja
        $route->get('satuan-kerja', 'SatuanKerjaController@index');
        $route->post('satuan-kerja/tambah', 'SatuanKerjaController@tambah');
        $route->get('satuan-kerja/{id}/edit', 'SatuanKerjaController@edit');
        $route->get('satuan-kerja/get-data', 'SatuanKerjaController@get_data');
        $route->get('satuan-kerja/{id}/hapus', 'SatuanKerjaController@hapus');

        $route->get('jenis-paten', 'JenisPatenController@index');
        $route->post('jenis-paten/tambah', 'JenisPatenController@tambah');
        $route->get('jenis-paten/{id}/edit', 'JenisPatenController@edit');
        $route->get('jenis-paten/get-data', 'JenisPatenController@get_data');
        $route->get('jenis-paten/{id}/hapus', 'JenisPatenController@hapus');

        $route->get('bidang-teknologi', 'BidangTeknologiController@index');
        $route->post('bidang-teknologi/tambah', 'BidangTeknologiController@tambah');
        $route->get('bidang-teknologi/{id}/edit', 'BidangTeknologiController@edit');
        $route->get('bidang-teknologi/get-data', 'BidangTeknologiController@get_data');
        $route->get('bidang-teknologi/{id}/hapus', 'BidangTeknologiController@hapus');
    });
});


// Route::get('/dashboard', function () {
//     return view('dashboard');
// })->middleware(['auth'])->name('dashboard');


